/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.yarn.util.BoundedAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBoundedAppender {
    @Test
    void initWithZeroLimitThrowsException() {
        Throwable exception = Assertions.assertThrows(IllegalArgumentException.class, () -> new BoundedAppender(0));
        Assertions.assertTrue((boolean)exception.getMessage().contains("limit should be positive"));
    }

    @Test
    void nullAppendedNullStringRead() {
        BoundedAppender boundedAppender = new BoundedAppender(4);
        boundedAppender.append(null);
        Assertions.assertEquals((Object)"null", (Object)boundedAppender.toString(), (String)"null appended, \"null\" read");
    }

    @Test
    void appendBelowLimitOnceValueIsReadCorrectly() {
        BoundedAppender boundedAppender = new BoundedAppender(2);
        boundedAppender.append((CharSequence)"ab");
        Assertions.assertEquals((Object)"ab", (Object)boundedAppender.toString(), (String)"value appended is read correctly");
    }

    @Test
    void appendValuesBelowLimitAreReadCorrectlyInFifoOrder() {
        BoundedAppender boundedAppender = new BoundedAppender(3);
        boundedAppender.append((CharSequence)"ab");
        boundedAppender.append((CharSequence)"cd");
        boundedAppender.append((CharSequence)"e");
        boundedAppender.append((CharSequence)"fg");
        Assertions.assertEquals((Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 7, "efg"), (Object)boundedAppender.toString(), (String)"last values appended fitting limit are read correctly");
    }

    @Test
    void appendLastAboveLimitPreservesLastMessagePostfix() {
        BoundedAppender boundedAppender = new BoundedAppender(3);
        boundedAppender.append((CharSequence)"ab");
        boundedAppender.append((CharSequence)"cde");
        boundedAppender.append((CharSequence)"fghij");
        Assertions.assertEquals((Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 10, "hij"), (Object)boundedAppender.toString(), (String)"last value appended above limit postfix is read correctly");
    }

    @Test
    void appendMiddleAboveLimitPreservesLastMessageAndMiddlePostfix() {
        BoundedAppender boundedAppender = new BoundedAppender(3);
        boundedAppender.append((CharSequence)"ab");
        boundedAppender.append((CharSequence)"cde");
        Assertions.assertEquals((Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 5, "cde"), (Object)boundedAppender.toString(), (String)"last value appended above limit postfix is read correctly");
        boundedAppender.append((CharSequence)"fg");
        Assertions.assertEquals((Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 7, "efg"), (Object)boundedAppender.toString(), (String)"middle value appended above limit postfix and last value are read correctly");
        boundedAppender.append((CharSequence)"hijkl");
        Assertions.assertEquals((Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 12, "jkl"), (Object)boundedAppender.toString(), (String)"last value appended above limit postfix is read correctly");
    }
}

