/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.nodelabels.NodeLabelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNodeLabelUtil {
    @Test
    void testAttributeValueAddition() {
        String[] invalidVals;
        String[] values;
        for (String val : values = new String[]{"1_8", "1.8", "ABZ", "ABZ", "az", "a-z", "a_z", "123456789"}) {
            try {
                NodeLabelUtil.checkAndThrowAttributeValue((String)val);
            }
            catch (Exception e) {
                Assertions.fail((String)("Valid values for NodeAttributeValue :" + val));
            }
        }
        for (String val : invalidVals = new String[]{"_18", "1,8", "1/5", ".15", "1\\5"}) {
            try {
                NodeLabelUtil.checkAndThrowAttributeValue((String)val);
                Assertions.fail((String)("Valid values for NodeAttributeValue :" + val));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    void testIsNodeAttributesEquals() {
        NodeAttribute nodeAttributeCK1V1 = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeCK1V1Copy = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK1V1 = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK1V1Copy = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK2V1 = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K2", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK2V2 = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K2", (NodeAttributeType)NodeAttributeType.STRING, (String)"V2");
        Assertions.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals(null, null));
        Assertions.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of(), (Set)ImmutableSet.of()));
        Assertions.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of((Object)nodeAttributeCK1V1Copy)));
        Assertions.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK1V1Copy)));
        Assertions.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1, (Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeCK1V1Copy, (Object)nodeAttributeDK1V1Copy)));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals(null, (Set)ImmutableSet.of()));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of(), null));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK1V1)));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK2V1)));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeDK2V1), (Set)ImmutableSet.of((Object)nodeAttributeDK2V2)));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of()));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of((Object)nodeAttributeCK1V1, (Object)nodeAttributeDK1V1)));
        Assertions.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1, (Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK1V1)));
    }
}

