/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.TFileAggregatedLogsBlock;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.log.AggregatedLogsBlockForTest;
import org.apache.hadoop.yarn.webapp.view.BlockForTest;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlBlockForTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAggregatedLogsBlock {
    @Test
    void testAccessDenied() throws Exception {
        FileUtil.fullyDelete((File)new File("target/logs"));
        Configuration configuration = this.getConfiguration();
        this.writeLogs("target/logs/logs/application_0_0001/container_0_0001_01_000001");
        this.writeLog(configuration, "owner");
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(data);
        HtmlBlockForTest html = new HtmlBlockForTest();
        BlockForTest block = new BlockForTest(html, printWriter, 10, false);
        TFileAggregatedLogsBlockForTest aggregatedBlock = this.getTFileAggregatedLogsBlockForTest(configuration, "owner", "container_0_0001_01_000001", "localhost:1234");
        aggregatedBlock.render(block);
        block.getWriter().flush();
        String out = data.toString();
        Assertions.assertTrue((boolean)out.contains("User [owner] is not authorized to view the logs for entity"));
    }

    @Test
    void testBlockContainsPortNumForUnavailableAppLog() {
        FileUtil.fullyDelete((File)new File("target/logs"));
        Configuration configuration = this.getConfiguration();
        String nodeName = configuration.get("yarn.nodemanager.webapp.address", "0.0.0.0:8042");
        AggregatedLogsBlockForTest aggregatedBlock = this.getAggregatedLogsBlockForTest(configuration, "admin", "container_0_0001_01_000001", nodeName);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(data);
        HtmlBlockForTest html = new HtmlBlockForTest();
        BlockForTest block = new BlockForTest(html, printWriter, 10, false);
        aggregatedBlock.render(block);
        block.getWriter().flush();
        String out = data.toString();
        Assertions.assertTrue((boolean)out.contains(nodeName));
    }

    @Test
    void testBadLogs() throws Exception {
        FileUtil.fullyDelete((File)new File("target/logs"));
        Configuration configuration = this.getConfiguration();
        this.writeLogs("target/logs/logs/application_0_0001/container_0_0001_01_000001");
        this.writeLog(configuration, "owner");
        AggregatedLogsBlockForTest aggregatedBlock = this.getAggregatedLogsBlockForTest(configuration, "admin", "container_0_0001_01_000001");
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(data);
        HtmlBlockForTest html = new HtmlBlockForTest();
        BlockForTest block = new BlockForTest(html, printWriter, 10, false);
        aggregatedBlock.render(block);
        block.getWriter().flush();
        String out = data.toString();
        Assertions.assertTrue((boolean)out.contains("Logs not available for entity. Aggregation may not be complete, Check back later or try to find the container logs in the local directory of nodemanager localhost:1234"));
        Assertions.assertTrue((boolean)out.contains("Or see application log at http://localhost:8042"));
    }

    @Test
    void testAggregatedLogsBlock() throws Exception {
        FileUtil.fullyDelete((File)new File("target/logs"));
        Configuration configuration = this.getConfiguration();
        this.writeLogs("target/logs/logs/application_0_0001/container_0_0001_01_000001");
        this.writeLog(configuration, "admin");
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(data);
        HtmlBlockForTest html = new HtmlBlockForTest();
        BlockForTest block = new BlockForTest(html, printWriter, 10, false);
        TFileAggregatedLogsBlockForTest aggregatedBlock = this.getTFileAggregatedLogsBlockForTest(configuration, "admin", "container_0_0001_01_000001", "localhost:1234");
        aggregatedBlock.render(block);
        block.getWriter().flush();
        String out = data.toString();
        Assertions.assertTrue((boolean)out.contains("test log1"));
        Assertions.assertTrue((boolean)out.contains("test log2"));
        Assertions.assertTrue((boolean)out.contains("test log3"));
    }

    @Test
    void testAggregatedLogsBlockHar() throws Exception {
        FileUtil.fullyDelete((File)new File("target/logs"));
        Configuration configuration = this.getConfiguration();
        URL harUrl = ClassLoader.getSystemClassLoader().getResource("application_1440536969523_0001.har");
        Assertions.assertNotNull((Object)harUrl);
        String path = "target/logs/admin/logs/application_1440536969523_0001/application_1440536969523_0001.har";
        FileUtils.copyDirectory((File)new File(harUrl.getPath()), (File)new File(path));
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(data);
        HtmlBlockForTest html = new HtmlBlockForTest();
        BlockForTest block = new BlockForTest(html, printWriter, 10, false);
        TFileAggregatedLogsBlockForTest aggregatedBlock = this.getTFileAggregatedLogsBlockForTest(configuration, "admin", "container_1440536969523_0001_01_000001", "host1:1111");
        aggregatedBlock.render(block);
        block.getWriter().flush();
        String out = data.toString();
        Assertions.assertTrue((boolean)out.contains("Hello stderr"));
        Assertions.assertTrue((boolean)out.contains("Hello stdout"));
        Assertions.assertTrue((boolean)out.contains("Hello syslog"));
        aggregatedBlock = this.getTFileAggregatedLogsBlockForTest(configuration, "admin", "container_1440536969523_0001_01_000002", "host2:2222");
        data = new ByteArrayOutputStream();
        printWriter = new PrintWriter(data);
        html = new HtmlBlockForTest();
        block = new BlockForTest(html, printWriter, 10, false);
        aggregatedBlock.render(block);
        block.getWriter().flush();
        out = data.toString();
        Assertions.assertTrue((boolean)out.contains("Goodbye stderr"));
        Assertions.assertTrue((boolean)out.contains("Goodbye stdout"));
        Assertions.assertTrue((boolean)out.contains("Goodbye syslog"));
    }

    @Test
    void testNoLogs() throws Exception {
        FileUtil.fullyDelete((File)new File("target/logs"));
        Configuration configuration = this.getConfiguration();
        File f = new File("target/logs/logs/application_0_0001/container_0_0001_01_000001");
        if (!f.exists()) {
            Assertions.assertTrue((boolean)f.mkdirs());
        }
        this.writeLog(configuration, "admin");
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(data);
        HtmlBlockForTest html = new HtmlBlockForTest();
        BlockForTest block = new BlockForTest(html, printWriter, 10, false);
        TFileAggregatedLogsBlockForTest aggregatedBlock = this.getTFileAggregatedLogsBlockForTest(configuration, "admin", "container_0_0001_01_000001", "localhost:1234");
        aggregatedBlock.render(block);
        block.getWriter().flush();
        String out = data.toString();
        Assertions.assertTrue((boolean)out.contains("No logs available for container container_0_0001_01_000001"));
    }

    private Configuration getConfiguration() {
        YarnConfiguration configuration = new YarnConfiguration();
        configuration.setBoolean("yarn.log-aggregation-enable", true);
        configuration.set("yarn.nodemanager.remote-app-log-dir", "target/logs");
        configuration.setBoolean("yarn.acl.enable", true);
        configuration.set("yarn.admin.acl", "admin");
        return configuration;
    }

    private AggregatedLogsBlockForTest getAggregatedLogsBlockForTest(Configuration configuration, String user, String containerId) {
        return this.getAggregatedLogsBlockForTest(configuration, user, containerId, "localhost:1234");
    }

    private TFileAggregatedLogsBlockForTest getTFileAggregatedLogsBlockForTest(Configuration configuration, String user, String containerId, String nodeName) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        View.ViewContext mockContext = (View.ViewContext)Mockito.mock(View.ViewContext.class);
        TFileAggregatedLogsBlockForTest aggregatedBlock = new TFileAggregatedLogsBlockForTest(mockContext, configuration);
        aggregatedBlock.setRequest(request);
        aggregatedBlock.moreParams().put("container.id", containerId);
        aggregatedBlock.moreParams().put("nm.id", nodeName);
        aggregatedBlock.moreParams().put("app.owner", user);
        aggregatedBlock.moreParams().put("start", "");
        aggregatedBlock.moreParams().put("end", "");
        aggregatedBlock.moreParams().put("entity.string", "entity");
        return aggregatedBlock;
    }

    private AggregatedLogsBlockForTest getAggregatedLogsBlockForTest(Configuration configuration, String user, String containerId, String nodeName) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        AggregatedLogsBlockForTest aggregatedBlock = new AggregatedLogsBlockForTest(configuration);
        aggregatedBlock.setRequest(request);
        aggregatedBlock.moreParams().put("container.id", containerId);
        aggregatedBlock.moreParams().put("nm.id", nodeName);
        aggregatedBlock.moreParams().put("app.owner", user);
        aggregatedBlock.moreParams().put("start", "");
        aggregatedBlock.moreParams().put("end", "");
        aggregatedBlock.moreParams().put("entity.string", "entity");
        return aggregatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(Configuration configuration, String user) throws Exception {
        ApplicationId appId = ApplicationIdPBImpl.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptIdPBImpl.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerIdPBImpl.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        String path = "target/logs/" + user + "/logs/application_0_0001/localhost_1234";
        File f = new File(path);
        if (!f.getParentFile().exists()) {
            Assertions.assertTrue((boolean)f.getParentFile().mkdirs());
        }
        List<String> rootLogDirs = Arrays.asList("target/logs/logs");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(configuration);
        LogAggregationFileController fileController = factory.getFileControllerForWrite();
        try {
            HashMap<ApplicationAccessType, String> appAcls = new HashMap<ApplicationAccessType, String>();
            appAcls.put(ApplicationAccessType.VIEW_APP, ugi.getUserName());
            NodeId nodeId = NodeId.newInstance((String)"localhost", (int)1234);
            LogAggregationFileControllerContext context = new LogAggregationFileControllerContext(new Path(path), new Path(path), false, 3600L, appId, appAcls, nodeId, ugi);
            fileController.initializeWriter(context);
            fileController.write(new AggregatedLogFormat.LogKey("container_0_0001_01_000001"), new AggregatedLogFormat.LogValue(rootLogDirs, containerId, UserGroupInformation.getCurrentUser().getShortUserName()));
        }
        finally {
            fileController.closeWriter();
        }
    }

    private void writeLogs(String dirName) throws Exception {
        File f = new File(dirName + File.separator + "log1");
        if (!f.getParentFile().exists()) {
            Assertions.assertTrue((boolean)f.getParentFile().mkdirs());
        }
        this.writeLog(dirName + File.separator + "log1", "test log1");
        this.writeLog(dirName + File.separator + "log2", "test log2");
        this.writeLog(dirName + File.separator + "log3", "test log3");
    }

    private void writeLog(String fileName, String text) throws Exception {
        File f = new File(fileName);
        FileWriter writer = new FileWriter(f);
        writer.write(text);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    private static class TFileAggregatedLogsBlockForTest
    extends TFileAggregatedLogsBlock {
        private Map<String, String> params = new HashMap<String, String>();
        private HttpServletRequest request;

        @Inject
        TFileAggregatedLogsBlockForTest(View.ViewContext ctx, Configuration conf) {
            super(ctx, conf, new Path("target/logs"), "logs");
        }

        public void render(HtmlBlock.Block html) {
            super.render(html);
        }

        public Map<String, String> moreParams() {
            return this.params;
        }

        public HttpServletRequest request() {
            return this.request;
        }

        public void setRequest(HttpServletRequest request) {
            this.request = request;
        }
    }
}

