/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AMRMClient<T extends ContainerRequest>
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AMRMClient.class);
    private TimelineV2Client timelineV2Client;
    private NMTokenCache nmTokenCache = NMTokenCache.getSingleton();

    @InterfaceAudience.Public
    public static <T extends ContainerRequest> AMRMClient<T> createAMRMClient() {
        AMRMClientImpl client = new AMRMClientImpl();
        return client;
    }

    @InterfaceAudience.Private
    protected AMRMClient(String name) {
        super(name);
    }

    public abstract RegisterApplicationMasterResponse registerApplicationMaster(String var1, int var2, String var3) throws YarnException, IOException;

    public abstract AllocateResponse allocate(float var1) throws YarnException, IOException;

    public abstract void unregisterApplicationMaster(FinalApplicationStatus var1, String var2, String var3) throws YarnException, IOException;

    public abstract void addContainerRequest(T var1);

    public abstract void removeContainerRequest(T var1);

    @Deprecated
    public void requestContainerResourceChange(Container container, Resource capability) {
        Preconditions.checkNotNull((Object)container, (Object)"Container cannot be null!!");
        Preconditions.checkNotNull((Object)capability, (Object)"UpdateContainerRequest cannot be null!!");
        this.requestContainerUpdate(container, UpdateContainerRequest.newInstance((int)container.getVersion(), (ContainerId)container.getId(), (ContainerUpdateType)(Resources.fitsIn((Resource)capability, (Resource)container.getResource()) ? ContainerUpdateType.DECREASE_RESOURCE : ContainerUpdateType.INCREASE_RESOURCE), (Resource)capability, null));
    }

    public abstract void requestContainerUpdate(Container var1, UpdateContainerRequest var2);

    public abstract void releaseAssignedContainer(ContainerId var1);

    public abstract Resource getAvailableResources();

    public abstract int getClusterNodeCount();

    @InterfaceStability.Evolving
    public abstract List<? extends Collection<T>> getMatchingRequests(Priority var1, String var2, Resource var3);

    @InterfaceStability.Evolving
    public List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, ExecutionType executionType, Resource capability) {
        throw new UnsupportedOperationException("The sub-class extending AMRMClient is expected to implement this !!");
    }

    @InterfaceStability.Evolving
    public abstract Collection<T> getMatchingRequests(long var1);

    public abstract void updateBlacklist(List<String> var1, List<String> var2);

    public void setNMTokenCache(NMTokenCache nmTokenCache) {
        this.nmTokenCache = nmTokenCache;
    }

    public NMTokenCache getNMTokenCache() {
        return this.nmTokenCache;
    }

    public void registerTimelineV2Client(TimelineV2Client client) {
        this.timelineV2Client = client;
    }

    public TimelineV2Client getRegisteredTimelineV2Client() {
        return this.timelineV2Client;
    }

    public void waitFor(Supplier<Boolean> check) throws InterruptedException {
        this.waitFor(check, 1000);
    }

    public void waitFor(Supplier<Boolean> check, int checkEveryMillis) throws InterruptedException {
        this.waitFor(check, checkEveryMillis, 1);
    }

    public void waitFor(Supplier<Boolean> check, int checkEveryMillis, int logInterval) throws InterruptedException {
        Preconditions.checkNotNull(check, (Object)"check should not be null");
        Preconditions.checkArgument((checkEveryMillis >= 0 ? 1 : 0) != 0, (Object)"checkEveryMillis should be positive value");
        Preconditions.checkArgument((logInterval >= 0 ? 1 : 0) != 0, (Object)"logInterval should be positive value");
        int loggingCounter = logInterval;
        while (true) {
            boolean result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Check the condition for main loop.");
            }
            if (result = ((Boolean)check.get()).booleanValue()) {
                LOG.info((Object)"Exits the main loop.");
                return;
            }
            if (--loggingCounter <= 0) {
                LOG.info((Object)"Waiting in main loop.");
                loggingCounter = logInterval;
            }
            Thread.sleep(checkEveryMillis);
        }
    }

    public static class ContainerRequest {
        private Resource capability;
        private List<String> nodes;
        private List<String> racks;
        private Priority priority;
        private long allocationRequestId;
        private boolean relaxLocality = true;
        private String nodeLabelsExpression;
        private ExecutionTypeRequest executionTypeRequest = ExecutionTypeRequest.newInstance();

        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority) {
            this(capability, nodes, racks, priority, true, null);
        }

        @InterfaceAudience.Public
        @InterfaceStability.Evolving
        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority, long allocationRequestId) {
            this(capability, nodes, racks, priority, allocationRequestId, true, null, ExecutionTypeRequest.newInstance());
        }

        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority, boolean relaxLocality) {
            this(capability, nodes, racks, priority, relaxLocality, null);
        }

        @InterfaceAudience.Public
        @InterfaceStability.Evolving
        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority, long allocationRequestId, boolean relaxLocality) {
            this(capability, nodes, racks, priority, allocationRequestId, relaxLocality, null, ExecutionTypeRequest.newInstance());
        }

        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority, boolean relaxLocality, String nodeLabelsExpression) {
            this(capability, nodes, racks, priority, 0L, relaxLocality, nodeLabelsExpression, ExecutionTypeRequest.newInstance());
        }

        @InterfaceAudience.Public
        @InterfaceStability.Evolving
        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority, long allocationRequestId, boolean relaxLocality, String nodeLabelsExpression) {
            this(capability, nodes, racks, priority, allocationRequestId, relaxLocality, nodeLabelsExpression, ExecutionTypeRequest.newInstance());
        }

        public ContainerRequest(Resource capability, String[] nodes, String[] racks, Priority priority, long allocationRequestId, boolean relaxLocality, String nodeLabelsExpression, ExecutionTypeRequest executionTypeRequest) {
            this.allocationRequestId = allocationRequestId;
            this.capability = capability;
            this.nodes = nodes != null ? ImmutableList.copyOf((Object[])nodes) : null;
            this.racks = racks != null ? ImmutableList.copyOf((Object[])racks) : null;
            this.priority = priority;
            this.relaxLocality = relaxLocality;
            this.nodeLabelsExpression = nodeLabelsExpression;
            this.executionTypeRequest = executionTypeRequest;
            this.sanityCheck();
        }

        private void sanityCheck() {
            Preconditions.checkArgument((this.capability != null ? 1 : 0) != 0, (Object)"The Resource to be requested for each container should not be null ");
            Preconditions.checkArgument((this.priority != null ? 1 : 0) != 0, (Object)"The priority at which to request containers should not be null ");
            Preconditions.checkArgument((this.relaxLocality || this.racks != null && this.racks.size() != 0 || this.nodes != null && this.nodes.size() != 0 ? 1 : 0) != 0, (Object)"Can't turn off locality relaxation on a request with no location constraints");
        }

        private ContainerRequest() {
        }

        public Resource getCapability() {
            return this.capability;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public List<String> getRacks() {
            return this.racks;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public long getAllocationRequestId() {
            return this.allocationRequestId;
        }

        public boolean getRelaxLocality() {
            return this.relaxLocality;
        }

        public String getNodeLabelExpression() {
            return this.nodeLabelsExpression;
        }

        public ExecutionTypeRequest getExecutionTypeRequest() {
            return this.executionTypeRequest;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Capability[").append(this.capability).append("]");
            sb.append("Priority[").append(this.priority).append("]");
            sb.append("AllocationRequestId[").append(this.allocationRequestId).append("]");
            sb.append("ExecutionTypeRequest[").append(this.executionTypeRequest).append("]");
            return sb.toString();
        }

        public static ContainerRequestBuilder newBuilder() {
            return new ContainerRequestBuilder();
        }

        public static final class ContainerRequestBuilder {
            private ContainerRequest containerRequest = new ContainerRequest();

            public ContainerRequestBuilder capability(Resource capability) {
                this.containerRequest.capability = capability;
                return this;
            }

            public ContainerRequestBuilder nodes(String[] nodes) {
                this.containerRequest.nodes = (List)(nodes != null ? ImmutableList.copyOf((Object[])nodes) : null);
                return this;
            }

            public ContainerRequestBuilder racks(String[] racks) {
                this.containerRequest.racks = (List)(racks != null ? ImmutableList.copyOf((Object[])racks) : null);
                return this;
            }

            public ContainerRequestBuilder priority(Priority priority) {
                this.containerRequest.priority = priority;
                return this;
            }

            public ContainerRequestBuilder allocationRequestId(long allocationRequestId) {
                this.containerRequest.allocationRequestId = allocationRequestId;
                return this;
            }

            public ContainerRequestBuilder relaxLocality(boolean relaxLocality) {
                this.containerRequest.relaxLocality = relaxLocality;
                return this;
            }

            public ContainerRequestBuilder nodeLabelsExpression(String nodeLabelsExpression) {
                this.containerRequest.nodeLabelsExpression = nodeLabelsExpression;
                return this;
            }

            public ContainerRequestBuilder executionTypeRequest(ExecutionTypeRequest executionTypeRequest) {
                this.containerRequest.executionTypeRequest = executionTypeRequest;
                return this;
            }

            public ContainerRequest build() {
                this.containerRequest.sanityCheck();
                return this.containerRequest;
            }
        }
    }
}

