/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.appcatalog.application;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.appcatalog.model.AppEntry;
import org.apache.hadoop.yarn.service.api.records.KerberosPrincipal;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ApiServiceClient;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnServiceClient {
    private static final Logger LOG = LoggerFactory.getLogger(YarnServiceClient.class);
    private static Configuration conf = new Configuration();
    private ApiServiceClient asc;

    private static ClientConfig getClientConfig() {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.chunkedEncodingSize", (Object)0);
        return config;
    }

    public YarnServiceClient() {
        try {
            this.asc = new ApiServiceClient(conf);
        }
        catch (Exception e) {
            LOG.error("Error initialize YARN Service Client.", (Throwable)e);
        }
    }

    public void createApp(Service app) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Response response;
            boolean useKerberos = UserGroupInformation.isSecurityEnabled();
            if (useKerberos) {
                KerberosPrincipal kerberos = new KerberosPrincipal();
                String[] temp = System.getenv("PRINCIPAL").split("@");
                String[] temp2 = temp[0].split("/");
                StringBuilder sb = new StringBuilder();
                sb.append(temp2[0]);
                sb.append("/");
                sb.append("_HOST");
                sb.append("@");
                sb.append(temp[1]);
                Object keytab = System.getenv("KEYTAB");
                if (!((String)keytab).startsWith("file://")) {
                    keytab = "file://" + (String)keytab;
                }
                kerberos.setPrincipalName(sb.toString());
                kerberos.setKeytab((String)keytab);
                app.setKerberosPrincipal(kerberos);
            }
            if ((response = this.asc.getApiClient().post(Entity.entity((Object)mapper.writeValueAsString((Object)app), (String)"application/json"))).getStatus() >= 299) {
                String message = (String)response.readEntity(String.class);
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus() + " error: " + message);
            }
        }
        catch (IOException e) {
            LOG.error("Error in deploying application: ", (Throwable)e);
        }
    }

    public void deleteApp(String appInstanceId) {
        try {
            Response response = (Response)this.asc.getApiClient(this.asc.getServicePath(appInstanceId)).delete(Response.class);
            if (response.getStatus() >= 299) {
                String message = (String)response.readEntity(String.class);
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus() + " error: " + message);
            }
        }
        catch (IOException e) {
            LOG.error("Error in deleting application.", (Throwable)e);
        }
    }

    public void restartApp(Service app) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String appInstanceId = app.getName();
        String yarnFile = mapper.writeValueAsString((Object)app);
        try {
            Response response = this.asc.getApiClient(this.asc.getServicePath(appInstanceId)).put(Entity.entity((Object)yarnFile, (String)"application/json"));
            if (response.getStatus() >= 299) {
                String message = (String)response.readEntity(String.class);
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus() + " error: " + message);
            }
        }
        catch (IOException e) {
            LOG.error("Error in restarting application.", (Throwable)e);
        }
    }

    public void stopApp(Service app) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String appInstanceId = app.getName();
        String yarnFile = mapper.writeValueAsString((Object)app);
        try {
            Response response = this.asc.getApiClient(this.asc.getServicePath(appInstanceId)).put(Entity.entity((Object)yarnFile, (String)"application/json"));
            if (response.getStatus() >= 299) {
                String message = (String)response.readEntity(String.class);
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus() + " error: " + message);
            }
        }
        catch (IOException e) {
            LOG.error("Error in stopping application.", (Throwable)e);
        }
    }

    public void getStatus(AppEntry entry) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String appInstanceId = entry.getName();
        Service app = null;
        try {
            String yarnFile = (String)this.asc.getApiClient(this.asc.getServicePath(appInstanceId)).get(String.class);
            app = (Service)mapper.readValue(yarnFile, Service.class);
            entry.setYarnfile(app);
        }
        catch (IOException e) {
            LOG.error("Error in fetching application status.", (Throwable)e);
        }
    }

    public void upgradeApp(Service app) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String appInstanceId = app.getName();
        app.setState(ServiceState.EXPRESS_UPGRADING);
        String yarnFile = mapper.writeValueAsString((Object)app);
        try {
            Response response = this.asc.getApiClient(this.asc.getServicePath(appInstanceId)).put(Entity.entity((Object)yarnFile, (String)"application/json"));
            if (response.getStatus() >= 299) {
                String message = (String)response.readEntity(String.class);
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus() + " error: " + message);
            }
        }
        catch (IOException e) {
            LOG.error("Error in stopping application.", (Throwable)e);
        }
    }
}

