/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;

@XmlRootElement(name="event")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
@JsonIgnoreProperties(ignoreUnknown=true, value={"infoJAXB"})
public class TimelineEvent
implements Comparable<TimelineEvent> {
    public static final long INVALID_TIMESTAMP = 0L;
    private String id;
    private HashMap<String, Object> info = new HashMap();
    private long timestamp;

    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String eventId) {
        this.id = eventId;
    }

    @InterfaceAudience.Private
    @XmlElement(name="info")
    public HashMap<String, Object> getInfoJAXB() {
        return this.info;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, Object> infos) {
        this.info = TimelineServiceHelper.mapCastToHashMap(infos);
    }

    public void addInfo(Map<String, Object> infos) {
        this.info.putAll(infos);
    }

    public void addInfo(String key, Object value) {
        this.info.put(key, value);
    }

    @XmlElement(name="timestamp")
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long ts) {
        this.timestamp = ts;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.id != null && this.timestamp != 0L;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimelineEvent)) {
            return false;
        }
        TimelineEvent event = (TimelineEvent)o;
        if (this.timestamp != event.timestamp) {
            return false;
        }
        return this.id.equals(event.id);
    }

    @Override
    public int compareTo(TimelineEvent other) {
        if (this.timestamp > other.timestamp) {
            return -1;
        }
        if (this.timestamp < other.timestamp) {
            return 1;
        }
        return this.id.compareTo(other.id);
    }
}

