/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestURL {
    TestURL() {
    }

    @Test
    void testConversion() throws Exception {
        String[] pathStrs;
        Configuration conf = new Configuration();
        conf.set("yarn.ipc.record.factory.class", RecordFactoryForTest.class.getName());
        for (String s : pathStrs = new String[]{"/", ".", "foo/bar", "foo", "/foo/bar/baz", "moo://bar/baz", "moo://bar:123/baz", "moo:///foo", "moo://foo@bar:123/baz/foo", "moo://foo@bar/baz/foo", "moo://foo@bar", "moo://foo:123"}) {
            Path path = new Path(s);
            Assertions.assertEquals((Object)path, (Object)URL.fromPath((Path)path, (Configuration)conf).toPath());
        }
        Path p = new Path("/foo/bar#baz");
        Assertions.assertEquals((Object)p, (Object)URL.fromPath((Path)p, (Configuration)conf).toPath());
    }

    public static class RecordFactoryForTest
    implements RecordFactory {
        private static final RecordFactoryForTest SELF = new RecordFactoryForTest();

        public <T> T newRecordInstance(Class<T> clazz) {
            return (T)((Object)new URLForTest());
        }

        public static RecordFactory get() {
            return SELF;
        }
    }

    public static class URLForTest
    extends URL {
        private String scheme;
        private String userInfo;
        private String host;
        private String file;
        private int port;

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getUserInfo() {
            return this.userInfo;
        }

        public void setUserInfo(String userInfo) {
            this.userInfo = userInfo;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

