/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;

@XmlRootElement(name="entity")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineEntity
implements Comparable<TimelineEntity> {
    protected static final String SYSTEM_INFO_KEY_PREFIX = "SYSTEM_INFO_";
    public static final long DEFAULT_ENTITY_PREFIX = 0L;
    private TimelineEntity real;
    private Identifier identifier;
    private HashMap<String, Object> info = new HashMap();
    private HashMap<String, String> configs = new HashMap();
    private Set<TimelineMetric> metrics = new HashSet<TimelineMetric>();
    private NavigableSet<TimelineEvent> events = new TreeSet<TimelineEvent>();
    private HashMap<String, Set<String>> isRelatedToEntities = new HashMap();
    private HashMap<String, Set<String>> relatesToEntities = new HashMap();
    private Long createdTime;
    private long idPrefix;

    public TimelineEntity() {
        this.identifier = new Identifier();
    }

    public TimelineEntity(TimelineEntity entity) {
        this.real = entity.getReal();
    }

    protected TimelineEntity(String type) {
        this();
        this.identifier.type = type;
    }

    @XmlElement(name="type")
    public String getType() {
        if (this.real == null) {
            return this.identifier.type;
        }
        return this.real.getType();
    }

    public void setType(String type) {
        if (this.real == null) {
            this.identifier.type = type;
        } else {
            this.real.setType(type);
        }
    }

    @XmlElement(name="id")
    public String getId() {
        if (this.real == null) {
            return this.identifier.id;
        }
        return this.real.getId();
    }

    public void setId(String id) {
        if (this.real == null) {
            this.identifier.id = id;
        } else {
            this.real.setId(id);
        }
    }

    public Identifier getIdentifier() {
        if (this.real == null) {
            return this.identifier;
        }
        return this.real.getIdentifier();
    }

    public void setIdentifier(Identifier entityIdentifier) {
        if (this.real == null) {
            this.identifier = entityIdentifier;
        } else {
            this.real.setIdentifier(entityIdentifier);
        }
    }

    @InterfaceAudience.Private
    @XmlElement(name="info")
    public HashMap<String, Object> getInfoJAXB() {
        if (this.real == null) {
            return this.info;
        }
        return this.real.getInfoJAXB();
    }

    public Map<String, Object> getInfo() {
        if (this.real == null) {
            return this.info;
        }
        return this.real.getInfo();
    }

    public void setInfo(Map<String, Object> entityInfos) {
        if (this.real == null) {
            this.info = TimelineServiceHelper.mapCastToHashMap(entityInfos);
        } else {
            this.real.setInfo(entityInfos);
        }
    }

    public void addInfo(Map<String, Object> entityInfos) {
        if (this.real == null) {
            this.info.putAll(entityInfos);
        } else {
            this.real.addInfo(entityInfos);
        }
    }

    public void addInfo(String key, Object value) {
        if (this.real == null) {
            this.info.put(key, value);
        } else {
            this.real.addInfo(key, value);
        }
    }

    @InterfaceAudience.Private
    @XmlElement(name="configs")
    public HashMap<String, String> getConfigsJAXB() {
        if (this.real == null) {
            return this.configs;
        }
        return this.real.getConfigsJAXB();
    }

    public Map<String, String> getConfigs() {
        if (this.real == null) {
            return this.configs;
        }
        return this.real.getConfigs();
    }

    public void setConfigs(Map<String, String> entityConfigs) {
        if (this.real == null) {
            this.configs = TimelineServiceHelper.mapCastToHashMap(entityConfigs);
        } else {
            this.real.setConfigs(entityConfigs);
        }
    }

    public void addConfigs(Map<String, String> entityConfigs) {
        if (this.real == null) {
            this.configs.putAll(entityConfigs);
        } else {
            this.real.addConfigs(entityConfigs);
        }
    }

    public void addConfig(String key, String value) {
        if (this.real == null) {
            this.configs.put(key, value);
        } else {
            this.real.addConfig(key, value);
        }
    }

    @XmlElement(name="metrics")
    public Set<TimelineMetric> getMetrics() {
        if (this.real == null) {
            return this.metrics;
        }
        return this.real.getMetrics();
    }

    public void setMetrics(Set<TimelineMetric> entityMetrics) {
        if (this.real == null) {
            this.metrics = entityMetrics;
        } else {
            this.real.setMetrics(entityMetrics);
        }
    }

    public void addMetrics(Set<TimelineMetric> entityMetrics) {
        if (this.real == null) {
            this.metrics.addAll(entityMetrics);
        } else {
            this.real.addMetrics(entityMetrics);
        }
    }

    public void addMetric(TimelineMetric metric) {
        if (this.real == null) {
            this.metrics.add(metric);
        } else {
            this.real.addMetric(metric);
        }
    }

    @XmlElement(name="events")
    public NavigableSet<TimelineEvent> getEvents() {
        if (this.real == null) {
            return this.events;
        }
        return this.real.getEvents();
    }

    public void setEvents(NavigableSet<TimelineEvent> entityEvents) {
        if (this.real == null) {
            this.events = entityEvents;
        } else {
            this.real.setEvents(entityEvents);
        }
    }

    public void addEvents(Set<TimelineEvent> entityEvents) {
        if (this.real == null) {
            this.events.addAll(entityEvents);
        } else {
            this.real.addEvents(entityEvents);
        }
    }

    public void addEvent(TimelineEvent event) {
        if (this.real == null) {
            this.events.add(event);
        } else {
            this.real.addEvent(event);
        }
    }

    public Map<String, Set<String>> getIsRelatedToEntities() {
        if (this.real == null) {
            return this.isRelatedToEntities;
        }
        return this.real.getIsRelatedToEntities();
    }

    @InterfaceAudience.Private
    @XmlElement(name="isrelatedto")
    public HashMap<String, Set<String>> getIsRelatedToEntitiesJAXB() {
        if (this.real == null) {
            return this.isRelatedToEntities;
        }
        return this.real.getIsRelatedToEntitiesJAXB();
    }

    @JsonSetter(value="isrelatedto")
    public void setIsRelatedToEntities(Map<String, Set<String>> isRelatedTo) {
        if (this.real == null) {
            this.isRelatedToEntities = TimelineServiceHelper.mapCastToHashMap(isRelatedTo);
        } else {
            this.real.setIsRelatedToEntities(isRelatedTo);
        }
    }

    public void addIsRelatedToEntities(Map<String, Set<String>> isRelatedTo) {
        if (this.real == null) {
            for (Map.Entry<String, Set<String>> entry : isRelatedTo.entrySet()) {
                Set<String> ids = this.isRelatedToEntities.get(entry.getKey());
                if (ids == null) {
                    ids = new HashSet<String>();
                    this.isRelatedToEntities.put(entry.getKey(), ids);
                }
                ids.addAll((Collection<String>)entry.getValue());
            }
        } else {
            this.real.addIsRelatedToEntities(isRelatedTo);
        }
    }

    public void addIsRelatedToEntity(String type, String id) {
        if (this.real == null) {
            Set<String> ids = this.isRelatedToEntities.get(type);
            if (ids == null) {
                ids = new HashSet<String>();
                this.isRelatedToEntities.put(type, ids);
            }
            ids.add(id);
        } else {
            this.real.addIsRelatedToEntity(type, id);
        }
    }

    @InterfaceAudience.Private
    @XmlElement(name="relatesto")
    public HashMap<String, Set<String>> getRelatesToEntitiesJAXB() {
        if (this.real == null) {
            return this.relatesToEntities;
        }
        return this.real.getRelatesToEntitiesJAXB();
    }

    public Map<String, Set<String>> getRelatesToEntities() {
        if (this.real == null) {
            return this.relatesToEntities;
        }
        return this.real.getRelatesToEntities();
    }

    public void addRelatesToEntities(Map<String, Set<String>> relatesTo) {
        if (this.real == null) {
            for (Map.Entry<String, Set<String>> entry : relatesTo.entrySet()) {
                Set<String> ids = this.relatesToEntities.get(entry.getKey());
                if (ids == null) {
                    ids = new HashSet<String>();
                    this.relatesToEntities.put(entry.getKey(), ids);
                }
                ids.addAll((Collection<String>)entry.getValue());
            }
        } else {
            this.real.addRelatesToEntities(relatesTo);
        }
    }

    public void addRelatesToEntity(String type, String id) {
        if (this.real == null) {
            Set<String> ids = this.relatesToEntities.get(type);
            if (ids == null) {
                ids = new HashSet<String>();
                this.relatesToEntities.put(type, ids);
            }
            ids.add(id);
        } else {
            this.real.addRelatesToEntity(type, id);
        }
    }

    @JsonSetter(value="relatesto")
    public void setRelatesToEntities(Map<String, Set<String>> relatesTo) {
        if (this.real == null) {
            this.relatesToEntities = TimelineServiceHelper.mapCastToHashMap(relatesTo);
        } else {
            this.real.setRelatesToEntities(relatesTo);
        }
    }

    @XmlElement(name="createdtime")
    public Long getCreatedTime() {
        if (this.real == null) {
            return this.createdTime;
        }
        return this.real.getCreatedTime();
    }

    @JsonSetter(value="createdtime")
    public void setCreatedTime(Long createdTs) {
        if (this.real == null) {
            this.createdTime = createdTs;
        } else {
            this.real.setCreatedTime(createdTs);
        }
    }

    public void setUID(String uidKey, String uId) {
        if (this.real == null) {
            this.info.put(uidKey, uId);
        } else {
            this.real.addInfo(uidKey, uId);
        }
    }

    public boolean isValid() {
        return this.getId() != null && this.getType() != null;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimelineEntity)) {
            return false;
        }
        TimelineEntity other = (TimelineEntity)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    @Override
    public int compareTo(TimelineEntity other) {
        int comparison = this.getType().compareTo(other.getType());
        if (comparison == 0) {
            if (this.getIdPrefix() > other.getIdPrefix()) {
                return -1;
            }
            if (this.getIdPrefix() < other.getIdPrefix()) {
                return 1;
            }
            return this.getId().compareTo(other.getId());
        }
        return comparison;
    }

    protected TimelineEntity getReal() {
        return this.real == null ? this : this.real;
    }

    public String toString() {
        if (this.real == null) {
            return this.identifier.toString();
        }
        return this.real.toString();
    }

    @XmlElement(name="idprefix")
    public long getIdPrefix() {
        if (this.real == null) {
            return this.idPrefix;
        }
        return this.real.getIdPrefix();
    }

    @JsonSetter(value="idprefix")
    public void setIdPrefix(long entityIdPrefix) {
        if (this.real == null) {
            this.idPrefix = entityIdPrefix;
        } else {
            this.real.setIdPrefix(entityIdPrefix);
        }
    }

    @XmlRootElement(name="identifier")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Identifier {
        private String type;
        private String id;

        public Identifier(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public Identifier() {
        }

        @XmlElement(name="type")
        public String getType() {
            return this.type;
        }

        public void setType(String entityType) {
            this.type = entityType;
        }

        @XmlElement(name="id")
        public String getId() {
            return this.id;
        }

        public void setId(String entityId) {
            this.id = entityId;
        }

        public String toString() {
            return "TimelineEntity[type='" + this.type + "', id='" + this.id + "']";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)obj;
            if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
                return false;
            }
            return !(this.type == null ? other.getType() != null : !this.type.equals(other.getType()));
        }
    }
}

