/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class Resource
implements Comparable<Resource> {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(int memory, int vCores) {
        return new SimpleResource(memory, vCores);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(long memory, int vCores) {
        return new SimpleResource(memory, vCores);
    }

    @InterfaceAudience.Public
    @Deprecated
    public abstract int getMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public long getMemorySize() {
        throw new NotImplementedException("This method is implemented by ResourcePBImpl");
    }

    @InterfaceAudience.Public
    @Deprecated
    public abstract void setMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public void setMemorySize(long memory) {
        throw new NotImplementedException("This method is implemented by ResourcePBImpl");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract int getVirtualCores();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract void setVirtualCores(int var1);

    public int hashCode() {
        int prime = 263167;
        int result = (int)(939769357L + this.getMemorySize());
        result = 263167 * result + this.getVirtualCores();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return this.getMemorySize() == other.getMemorySize() && this.getVirtualCores() == other.getVirtualCores();
    }

    @Override
    public int compareTo(Resource other) {
        long diff = this.getMemorySize() - other.getMemorySize();
        if (diff == 0L) {
            diff = this.getVirtualCores() - other.getVirtualCores();
        }
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    }

    public String toString() {
        return "<memory:" + this.getMemorySize() + ", vCores:" + this.getVirtualCores() + ">";
    }

    private static class SimpleResource
    extends Resource {
        private long memory;
        private long vcores;

        SimpleResource(long memory, long vcores) {
            this.memory = memory;
            this.vcores = vcores;
        }

        @Override
        public int getMemory() {
            return (int)this.memory;
        }

        @Override
        public void setMemory(int memory) {
            this.memory = memory;
        }

        @Override
        public long getMemorySize() {
            return this.memory;
        }

        @Override
        public void setMemorySize(long memory) {
            this.memory = memory;
        }

        @Override
        public int getVirtualCores() {
            return (int)this.vcores;
        }

        @Override
        public void setVirtualCores(int vcores) {
            this.vcores = vcores;
        }
    }
}

