/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TOSClientContextUtils {
    public static final Logger LOG = LoggerFactory.getLogger(TOSClientContextUtils.class);

    private TOSClientContextUtils() {
    }

    public static String normalizeEndpoint(String endpoint) {
        for (String scheme : new String[]{"https://", "http://", "tos://"}) {
            if (!endpoint.startsWith(scheme)) continue;
            return endpoint.substring(scheme.length());
        }
        return endpoint;
    }

    public static String parseRegion(String endpoint) {
        String region = null;
        String newEndpoint = TOSClientContextUtils.normalizeEndpoint(endpoint);
        String[] parts = newEndpoint.split("\\.");
        if (parts.length == 3) {
            region = parts[0].replace("tos-", "");
        } else if (parts.length == 4) {
            region = parts[1].replace("tos-", "");
        } else if (parts.length == 6) {
            region = parts[2];
        } else if (parts.length == 7) {
            region = parts[3];
        }
        LOG.debug("parse region [{}] from endpoint [{}]", (Object)region, (Object)endpoint);
        return region;
    }
}

