/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import java.util.concurrent.ThreadLocalRandom;

public final class RetryableUtils {
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    private RetryableUtils() {
    }

    public static long backoff(int attempt) {
        double backoff;
        if (attempt == 0) {
            return 1000L;
        }
        double max = 10.0;
        for (backoff = 1.0; backoff < max && attempt > 0; backoff *= 1.6, --attempt) {
        }
        if (backoff > max) {
            backoff = max;
        }
        return (backoff *= 1.0 + 0.2 * (RANDOM.nextDouble(1.0) * 2.0 - 1.0)) < 0.0 ? 0L : (long)(backoff * 1000.0);
    }
}

