/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;

public final class RemoteIterators {
    private RemoteIterators() {
    }

    public static <T> RemoteIterator<T> fromSingleton(@Nullable T singleton) {
        return new SingletonIterator<T>(singleton);
    }

    public static <S, T> RemoteIterator<T> fromIterable(Iterable<S> iterator, FunctionRaisingIOE<S, T> mapper) {
        return new IterableRemoteIterator<S, T>(iterator, mapper);
    }

    private static final class SingletonIterator<T>
    implements RemoteIterator<T> {
        private final T singleton;
        private boolean processed;

        private SingletonIterator(@Nullable T singleton) {
            this.singleton = singleton;
            this.processed = singleton == null;
        }

        public boolean hasNext() {
            return !this.processed;
        }

        public T next() {
            if (this.hasNext()) {
                this.processed = true;
                return this.singleton;
            }
            throw new NoSuchElementException();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("singleton", this.singleton).toString();
        }
    }

    private static final class IterableRemoteIterator<S, T>
    implements RemoteIterator<T> {
        private final Iterator<S> sourceIterator;
        private final FunctionRaisingIOE<S, T> mapper;

        private IterableRemoteIterator(Iterable<S> source, FunctionRaisingIOE<S, T> mapper) {
            this.sourceIterator = source.iterator();
            this.mapper = mapper;
        }

        public boolean hasNext() {
            return this.sourceIterator.hasNext();
        }

        public T next() throws IOException {
            return this.mapper.apply(this.sourceIterator.next());
        }
    }

    public static interface FunctionRaisingIOE<S, T> {
        public T apply(S var1) throws IOException;
    }
}

