/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;

public final class Range {
    private final long off;
    private final long len;

    private Range(long off, long len) {
        this.off = off;
        this.len = len;
    }

    public static Range of(long off, long len) {
        return new Range(off, len);
    }

    public long off() {
        return this.off;
    }

    public long len() {
        return this.len;
    }

    public long end() {
        return this.off + this.len;
    }

    public boolean include(long pos) {
        return pos >= this.off && pos < this.off + this.len;
    }

    public boolean overlap(Range r) {
        return r.off() < this.end() && this.off() < r.end();
    }

    public int hashCode() {
        return Objects.hash(this.off, this.len);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range that = (Range)o;
        return Objects.equals(this.off, that.off) && Objects.equals(this.len, that.len);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.off).add("length", this.len).toString();
    }

    public static List<Range> split(long totalSize, long width) {
        Preconditions.checkArgument((totalSize >= 0L ? 1 : 0) != 0, (String)"Size %s must be >= 0", (Object[])new Object[]{totalSize});
        Preconditions.checkArgument((width > 0L ? 1 : 0) != 0, (String)"Width %s must be positive", (Object[])new Object[]{width});
        long remain = totalSize % width;
        long rangeNum = totalSize / width;
        ArrayList ranges = Lists.newArrayListWithCapacity((int)((int)rangeNum + (remain == 0L ? 0 : 1)));
        int i = 0;
        while ((long)i < rangeNum) {
            ranges.add(Range.of((long)i * width, width));
            ++i;
        }
        if (remain > 0L) {
            ranges.add(Range.of(totalSize - remain, remain));
        }
        return ranges;
    }
}

