/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.Preconditions;

public final class ParseUtils {
    private static final String ERROR_MSG = "Failed to parse value %s as %s, property key %s";

    private ParseUtils() {
    }

    public static String envAsString(String key) {
        return ParseUtils.envAsString(key, true);
    }

    public static String envAsString(String key, boolean allowNull) {
        String value = System.getenv(key);
        if (!allowNull) {
            Preconditions.checkNotNull((Object)value, (String)"os env key: %s cannot be null", (Object[])new Object[]{key});
        }
        return value;
    }

    public static String envAsString(String key, String defaultValue) {
        String value = System.getenv(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    public static boolean envAsBoolean(String key, boolean defaultValue) {
        String value = System.getenv(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        ParseUtils.checkBoolean(key, value);
        return Boolean.parseBoolean(value);
    }

    public static boolean isBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    public static void checkBoolean(String key, String value) {
        if (!ParseUtils.isBoolean(value)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG, value, "boolean", key));
        }
    }
}

