/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.tosfs.util.Reload;
import org.apache.hadoop.util.Lists;

public class LazyReloadIter<T>
implements Iterator<T> {
    private final List<T> buf = Lists.newArrayList();
    private final Reload<T> reload;
    private int cur = 0;
    private boolean exhausted = false;

    public LazyReloadIter(Reload<T> reload) {
        this.reload = reload;
    }

    @Override
    public boolean hasNext() {
        if (this.exhausted && this.buf.isEmpty()) {
            return false;
        }
        if (this.cur >= this.buf.size()) {
            this.buf.clear();
            this.cur = 0;
            boolean exhaust = this.reload.fill(this.buf);
            while (this.buf.isEmpty() && !exhaust) {
                exhaust = this.reload.fill(this.buf);
            }
            if (exhaust) {
                this.exhausted = true;
            }
            return !this.buf.isEmpty();
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.buf.get(this.cur++);
        }
        throw new NoSuchElementException();
    }
}

