/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JsonCodec<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true).configure(SerializationFeature.INDENT_OUTPUT, true).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private final Class<T> clazz;

    public JsonCodec(Class<T> clazz) {
        this.clazz = clazz;
    }

    public byte[] toBytes(T instance) throws IOException {
        return MAPPER.writeValueAsBytes(instance);
    }

    public T fromBytes(byte[] data) throws IOException {
        return (T)MAPPER.readValue(new String(data, 0, data.length, StandardCharsets.UTF_8), this.clazz);
    }
}

