/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.util.Preconditions;

public final class Iterables {
    private Iterables() {
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> fromIterable, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(fromIterable);
        Preconditions.checkNotNull(function);
        return () -> new Iterator<T>(){
            private Iterator<F> iterator;
            {
                this.iterator = fromIterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return function.apply(this.iterator.next());
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> unfiltered, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(predicate);
        return () -> new Iterator<T>(){
            private Iterator<T> iterator;
            private boolean advance;
            private T value;
            {
                this.iterator = unfiltered.iterator();
                this.advance = true;
            }

            @Override
            public boolean hasNext() {
                if (!this.advance) {
                    return true;
                }
                while (this.iterator.hasNext()) {
                    this.value = this.iterator.next();
                    if (!predicate.test(this.value)) continue;
                    this.advance = false;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.advance = true;
                    return this.value;
                }
                throw new NoSuchElementException("No more items in iterator.");
            }
        };
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> inputs) {
        return () -> new ConcatenatedIterator(inputs.iterator());
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends Iterable<? extends T>> iterators;
        private Iterator<? extends T> curIter;

        ConcatenatedIterator(Iterator<? extends Iterable<? extends T>> iterators) {
            Preconditions.checkNotNull(iterators, (Object)"Iterators should not be null.");
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while (this.curIter == null || !this.curIter.hasNext()) {
                if (this.curIter != null) {
                    this.curIter = null;
                }
                if (!this.iterators.hasNext()) {
                    return false;
                }
                this.curIter = this.iterators.next().iterator();
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.curIter.next();
            }
            throw new NoSuchElementException("No more elements");
        }
    }
}

