/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.util;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.Preconditions;

public final class FSUtils {
    private static final String OVERFLOW_ERROR_HINT = "Requested more bytes than destination buffer size: request length = %s, with offset = %s, buffer capacity = %s";

    private FSUtils() {
    }

    public static void checkReadParameters(byte[] buffer, int offset, int length) {
        Preconditions.checkArgument((buffer != null ? 1 : 0) != 0, (Object)"Null buffer");
        if (offset < 0 || offset > buffer.length) {
            throw new IndexOutOfBoundsException(String.format("offset: %s is out of range [%s, %s]", offset, 0, buffer.length));
        }
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length: %s is negative", (Object[])new Object[]{length});
        if (buffer.length < offset + length) {
            throw new IndexOutOfBoundsException(String.format(OVERFLOW_ERROR_HINT, length, offset, buffer.length - offset));
        }
    }

    public static URI normalizeURI(URI fsUri, Configuration hadoopConfig) {
        URI defaultUri;
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        if (scheme == null && authority == null) {
            fsUri = FileSystem.getDefaultUri((Configuration)hadoopConfig);
        } else if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri((Configuration)hadoopConfig)).getScheme()) && defaultUri.getAuthority() != null) {
            fsUri = defaultUri;
        }
        return fsUri;
    }

    public static String scheme(Configuration conf, URI uri) {
        if (uri.getScheme() == null || uri.getScheme().isEmpty()) {
            return FileSystem.getDefaultUri((Configuration)conf).getScheme();
        }
        return uri.getScheme();
    }
}

