/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.ops;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.tosfs.RawFileStatus;
import org.apache.hadoop.fs.tosfs.object.DirectoryStorage;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.fs.tosfs.object.ObjectUtils;
import org.apache.hadoop.fs.tosfs.ops.FsOps;
import org.apache.hadoop.fs.tosfs.util.Iterables;

public class DirectoryFsOps
implements FsOps {
    private final DirectoryStorage storage;
    private final Function<ObjectInfo, RawFileStatus> objMapper;

    public DirectoryFsOps(DirectoryStorage storage, Function<ObjectInfo, RawFileStatus> objMapper) {
        this.storage = storage;
        this.objMapper = objMapper;
    }

    @Override
    public void renameFile(Path src, Path dst, long length) {
        this.innerRename(src, dst, false);
    }

    @Override
    public void renameDir(Path src, Path dst) {
        this.innerRename(src, dst, true);
    }

    private void innerRename(Path src, Path dst, boolean isDir) {
        String dstParentKey = ObjectUtils.pathToKey(dst.getParent(), true);
        if (!dstParentKey.isEmpty() && this.storage.head(dstParentKey) == null) {
            this.mkdirs(dst.getParent());
        }
        String srcKey = ObjectUtils.pathToKey(src, isDir);
        String dstKey = ObjectUtils.pathToKey(dst, isDir);
        this.storage.rename(srcKey, dstKey);
    }

    @Override
    public void deleteFile(Path file) {
        this.storage.delete(ObjectUtils.pathToKey(file));
    }

    @Override
    public void deleteDir(Path dir, boolean recursive) throws IOException {
        String dirKey = ObjectUtils.pathToKey(dir, true);
        if (recursive) {
            this.storage.deleteAll(dirKey);
        } else if (this.isEmptyDirectory(dir)) {
            this.storage.delete(dirKey);
        } else {
            throw new PathIsNotEmptyDirectoryException(dir.toString());
        }
    }

    @Override
    public Iterable<RawFileStatus> listDir(Path dir, boolean recursive, Predicate<String> postFilter) {
        String key = ObjectUtils.pathToKey(dir, true);
        Iterable<ObjectInfo> objs = Iterables.filter(this.storage.listDir(key, recursive), obj -> postFilter.test(obj.key()));
        return Iterables.transform(objs, this.objMapper);
    }

    @Override
    public boolean isEmptyDirectory(Path dir) {
        return this.storage.isEmptyDir(ObjectUtils.pathToKey(dir, true));
    }

    @Override
    public void mkdirs(Path dir) {
        if (dir.isRoot()) {
            return;
        }
        String key = ObjectUtils.pathToKey(dir, true);
        this.storage.put(key, new byte[0]);
    }
}

