/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.ops;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.tosfs.RawFileStatus;
import org.apache.hadoop.fs.tosfs.conf.ConfKeys;
import org.apache.hadoop.fs.tosfs.object.Constants;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.object.ObjectUtils;
import org.apache.hadoop.fs.tosfs.object.request.ListObjectsRequest;
import org.apache.hadoop.fs.tosfs.object.response.ListObjectsResponse;
import org.apache.hadoop.fs.tosfs.ops.FsOps;
import org.apache.hadoop.fs.tosfs.ops.RenameOp;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;
import org.apache.hadoop.fs.tosfs.util.Iterables;
import org.apache.hadoop.util.Lists;

public class DefaultFsOps
implements FsOps {
    private final ObjectStorage storage;
    private final ExecutorService taskThreadPool;
    private final Function<ObjectInfo, RawFileStatus> objMapper;
    private final RenameOp renameOp;
    private final boolean asyncCreateParentDir;

    public DefaultFsOps(ObjectStorage storage, Configuration conf, ExecutorService taskThreadPool, Function<ObjectInfo, RawFileStatus> objMapper) {
        this.storage = storage;
        this.taskThreadPool = taskThreadPool;
        this.objMapper = objMapper;
        this.renameOp = new RenameOp(conf, storage, taskThreadPool);
        this.asyncCreateParentDir = conf.getBoolean(ConfKeys.FS_ASYNC_CREATE_MISSED_PARENT.key(storage.scheme()), true);
    }

    @Override
    public void renameFile(Path src, Path dst, long length) {
        this.renameOp.renameFile(src, dst, length);
        this.mkdirIfNecessary(src.getParent(), this.asyncCreateParentDir);
    }

    @Override
    public void renameDir(Path src, Path dst) {
        this.renameOp.renameDir(src, dst);
        this.mkdirIfNecessary(src.getParent(), this.asyncCreateParentDir);
    }

    @Override
    public void deleteFile(Path file) {
        this.storage.delete(ObjectUtils.pathToKey(file));
        this.mkdirIfNecessary(file.getParent(), this.asyncCreateParentDir);
    }

    @Override
    public void deleteDir(Path dir, boolean recursive) throws IOException {
        String dirKey = ObjectUtils.pathToKey(dir, true);
        if (recursive) {
            this.storage.deleteAll(dirKey);
        } else if (this.isEmptyDirectory(dir)) {
            this.storage.delete(dirKey);
        } else {
            throw new PathIsNotEmptyDirectoryException(dir.toString());
        }
    }

    @Override
    public Iterable<RawFileStatus> listDir(Path dir, boolean recursive, Predicate<String> postFilter) {
        String key = ObjectUtils.pathToKey(dir, true);
        String delimiter = recursive ? null : "/";
        ListObjectsRequest req = ListObjectsRequest.builder().prefix(key).startAfter(key).delimiter(delimiter).build();
        return Iterables.transform(this.asObjectInfo(this.storage.list(req), postFilter), this.objMapper);
    }

    @Override
    public boolean isEmptyDirectory(Path dir) {
        String key = ObjectUtils.pathToKey(dir, true);
        ListObjectsRequest req = ListObjectsRequest.builder().prefix(key).startAfter(key).delimiter("/").maxKeys(1).build();
        return !this.asObjectInfo(this.storage.list(req), s -> true).iterator().hasNext();
    }

    @Override
    public void mkdirs(Path dir) {
        if (dir.isRoot()) {
            return;
        }
        String key = ObjectUtils.pathToKey(dir, true);
        this.storage.put(key, new byte[0]);
        Path parentPath = dir.getParent();
        String parentKey = ObjectUtils.pathToKey(parentPath, true);
        while (!parentPath.isRoot() && this.storage.head(parentKey) == null) {
            this.storage.put(parentKey, new byte[0]);
            parentPath = parentPath.getParent();
            parentKey = ObjectUtils.pathToKey(parentPath, true);
        }
    }

    private void mkdirIfNecessary(Path path, boolean async) {
        if (path != null) {
            CommonUtils.runQuietly(() -> {
                Future<?> future = this.taskThreadPool.submit(() -> {
                    String key = ObjectUtils.pathToKey(path, true);
                    if (!key.isEmpty() && this.storage.head(key) == null) {
                        this.mkdirs(ObjectUtils.keyToPath(key));
                    }
                });
                if (!async) {
                    future.get();
                }
            });
        }
    }

    private Iterable<ObjectInfo> asObjectInfo(Iterable<ListObjectsResponse> listResponses, Predicate<String> filter) {
        Iterable<List> results = Iterables.transform(listResponses, listResp -> {
            ArrayList objs = Lists.newArrayList();
            objs.addAll(listResp.objects());
            for (String prefix : listResp.commonPrefixes()) {
                objs.add(new ObjectInfo(prefix, 0L, new Date(), Constants.MAGIC_CHECKSUM, true));
            }
            return objs;
        });
        return Iterables.filter(Iterables.concat(results), o -> filter.test(o.key()));
    }
}

