/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos.auth;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.conf.TosKeys;
import org.apache.hadoop.fs.tosfs.object.tos.auth.AbstractCredentialsProvider;
import org.apache.hadoop.fs.tosfs.object.tos.auth.ExpireableCredential;

public class SimpleCredentialsProvider
extends AbstractCredentialsProvider {
    public static final String NAME = SimpleCredentialsProvider.class.getName();

    @Override
    protected ExpireableCredential createCredential() {
        String accessKey = SimpleCredentialsProvider.lookup(this.conf(), TosKeys.FS_TOS_BUCKET_ACCESS_KEY_ID.key(this.bucket()), "fs.tos.access-key-id");
        String secretKey = SimpleCredentialsProvider.lookup(this.conf(), TosKeys.FS_TOS_BUCKET_SECRET_ACCESS_KEY.key(this.bucket()), "fs.tos.secret-access-key");
        String sessionToken = SimpleCredentialsProvider.lookup(this.conf(), TosKeys.FS_TOS_BUCKET_SESSION_TOKEN.key(this.bucket()), "fs.tos.session-token");
        if (StringUtils.isEmpty((CharSequence)sessionToken)) {
            return new ExpireableCredential(accessKey, secretKey);
        }
        return new ExpireableCredential(accessKey, secretKey, sessionToken, Long.MAX_VALUE);
    }

    static String lookup(Configuration conf, String key, String fallbackKey) {
        String dynValue;
        if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)(dynValue = conf.get(key)))) {
            return dynValue;
        }
        return conf.get(fallbackKey);
    }
}

