/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos.auth;

import com.volcengine.tos.auth.Credential;
import org.apache.hadoop.util.Preconditions;

public class ExpireableCredential
extends Credential {
    public static final int EXPIRED_INTERVAL_MILLIS = 60000;
    private final long expireTimeMills;

    public ExpireableCredential(String accessKeyId, String accessKeySecret) {
        this(accessKeyId, accessKeySecret, "", Long.MAX_VALUE);
    }

    public ExpireableCredential(String accessKeyId, String accessKeySecret, String sessionToken, long expireTimeMills) {
        super(accessKeyId, accessKeySecret, sessionToken);
        Preconditions.checkNotNull((Object)accessKeyId, (String)"%s cannot be null", (Object[])new Object[]{"fs.tos.access-key-id"});
        Preconditions.checkNotNull((Object)accessKeySecret, (String)"%s cannot be null", (Object[])new Object[]{"fs.tos.secret-access-key"});
        Preconditions.checkArgument((expireTimeMills > 0L ? 1 : 0) != 0, (Object)"expiredTime must be > 0");
        this.expireTimeMills = expireTimeMills;
    }

    public boolean isExpired() {
        return this.expireTimeMills - System.currentTimeMillis() <= 60000L;
    }
}

