/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos.auth;

import com.volcengine.tos.TosException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.conf.TosKeys;
import org.apache.hadoop.fs.tosfs.object.tos.auth.AbstractCredentialsProvider;
import org.apache.hadoop.fs.tosfs.object.tos.auth.ExpireableCredential;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCredentialsProviderChain
extends AbstractCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCredentialsProviderChain.class);
    private final List<AbstractCredentialsProvider> providers = new LinkedList<AbstractCredentialsProvider>();
    private volatile AbstractCredentialsProvider lastUsedProvider;

    @Override
    public void initialize(Configuration config, String bucketName) {
        super.initialize(config, bucketName);
        this.loadAllCredentialProviders();
    }

    private void loadAllCredentialProviders() {
        for (String providerClazz : this.getCustomProviderClasses()) {
            try {
                Class<?> clazz = Class.forName(providerClazz);
                AbstractCredentialsProvider credentialsProvider = (AbstractCredentialsProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                credentialsProvider.initialize(this.conf(), this.bucket());
                this.providers.add(credentialsProvider);
            }
            catch (Exception e) {
                LOG.error("Failed to initialize credential provider for {}", (Object)providerClazz, (Object)e);
                throw new TosException(e);
            }
        }
    }

    private String[] getCustomProviderClasses() {
        String[] classes = this.conf().getStringCollection("fs.tos.credential.provider.custom.classes").toArray(new String[0]);
        if (classes.length == 0) {
            classes = TosKeys.FS_TOS_CUSTOM_CREDENTIAL_PROVIDER_CLASSES_DEFAULT;
        }
        return classes;
    }

    @Override
    protected ExpireableCredential createCredential() {
        if (this.lastUsedProvider != null) {
            return this.lastUsedProvider.credential();
        }
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (AbstractCredentialsProvider provider : this.providers) {
            try {
                ExpireableCredential credential = provider.credential();
                LOG.debug("Access credential from {} successfully, choose it as the candidate provider", (Object)provider.getClass().getName());
                this.lastUsedProvider = provider;
                return credential;
            }
            catch (Exception e) {
                LOG.debug("Failed to access credential from provider {}", (Object)provider.getClass().getName(), (Object)e);
                exceptions.add(e);
            }
        }
        String errorMsg = "Unable to load TOS credentials from any provider in the chain.";
        RuntimeException runtimeException = new RuntimeException(errorMsg);
        exceptions.forEach(runtimeException::addSuppressed);
        throw runtimeException;
    }

    @VisibleForTesting
    AbstractCredentialsProvider lastUsedProvider() {
        Preconditions.checkNotNull((Object)this.lastUsedProvider, (Object)"provider cannot be null");
        return this.lastUsedProvider;
    }
}

