/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos.auth;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.object.tos.auth.CredentialsProvider;
import org.apache.hadoop.fs.tosfs.object.tos.auth.ExpireableCredential;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCredentialsProvider.class);
    private volatile ExpireableCredential credential;
    private Configuration conf;
    private String bucket;

    @Override
    public void initialize(Configuration config, String bucketName) {
        this.conf = config;
        this.bucket = bucketName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExpireableCredential credential() {
        if (this.credential == null || this.credential.isExpired()) {
            AbstractCredentialsProvider abstractCredentialsProvider = this;
            synchronized (abstractCredentialsProvider) {
                if (this.credential == null || this.credential.isExpired()) {
                    LOG.debug("Credential expired, create a new credential");
                    ExpireableCredential cred = this.createCredential();
                    Preconditions.checkNotNull((Object)cred.getAccessKeyId(), (String)"%s cannot be null", (Object[])new Object[]{"fs.tos.access-key-id"});
                    Preconditions.checkNotNull((Object)cred.getAccessKeySecret(), (String)"%s cannot be null", (Object[])new Object[]{"fs.tos.secret-access-key"});
                    this.credential = cred;
                }
            }
        }
        return this.credential;
    }

    public Configuration conf() {
        return this.conf;
    }

    public String bucket() {
        return this.bucket;
    }

    protected abstract ExpireableCredential createCredential();
}

