/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;

public class TosObjectInfo
extends ObjectInfo {
    private final String crc64ecma;
    private final boolean appendable;

    public TosObjectInfo(String key, long size, Date mtime, byte[] checksum, boolean isDir, boolean appendable, String crc64ecma) {
        super(key, size, mtime, checksum, isDir);
        this.crc64ecma = crc64ecma;
        this.appendable = appendable;
    }

    public String crc64ecma() {
        return this.crc64ecma;
    }

    public boolean appendable() {
        return this.appendable;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof TosObjectInfo)) {
            return false;
        }
        TosObjectInfo that = (TosObjectInfo)o;
        return Objects.equals(this.appendable, that.appendable) && Objects.equals(this.crc64ecma, that.crc64ecma);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.appendable, this.crc64ecma);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key()).add("size", this.size()).add("mtime", (Object)this.mtime()).add("checksum", (Object)Hex.encodeHexString((byte[])this.checksum())).add("isDir", this.isDir()).add("appendable", this.appendable).add("crc64ecma", (Object)this.crc64ecma).toString();
    }
}

