/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos;

import com.volcengine.tos.model.object.GetFileStatusOutput;
import com.volcengine.tos.model.object.ListedObjectV2;
import java.util.Map;
import org.apache.hadoop.fs.tosfs.common.Bytes;
import org.apache.hadoop.fs.tosfs.object.ChecksumInfo;
import org.apache.hadoop.fs.tosfs.object.ChecksumType;
import org.apache.hadoop.fs.tosfs.object.Constants;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;

public final class TOSUtils {
    public static final Map<ChecksumType, String> CHECKSUM_HEADER = ImmutableMap.of((Object)((Object)ChecksumType.CRC32C), (Object)"x-tos-hash-crc32c", (Object)((Object)ChecksumType.CRC64ECMA), (Object)"x-tos-hash-crc64ecma");
    public static final String OBJECT_TYPE_KEY = "x-tos-object-type";
    public static final String APPENDABLE_TYPE_VALUE = "Appendable";

    private TOSUtils() {
    }

    public static byte[] parseChecksum(Map<String, String> headers, ChecksumInfo checksumInfo) {
        ChecksumType type = checksumInfo.checksumType();
        String header = CHECKSUM_HEADER.get((Object)type);
        if (header == null) {
            return Constants.MAGIC_CHECKSUM;
        }
        String checksumStr = headers.get(header);
        if (checksumStr == null) {
            return Constants.MAGIC_CHECKSUM;
        }
        return TOSUtils.parseChecksumStringToBytes(checksumStr, type);
    }

    public static byte[] parseChecksum(ListedObjectV2 obj, ChecksumInfo checksumInfo) {
        String checksumStr;
        ChecksumType type = checksumInfo.checksumType();
        if (type == ChecksumType.CRC32C) {
            checksumStr = obj.getHashCrc32c();
        } else if (type == ChecksumType.CRC64ECMA) {
            checksumStr = obj.getHashCrc64ecma();
        } else {
            throw new IllegalArgumentException(String.format("Checksum type %s is not supported by TOS.", type.name()));
        }
        if (checksumStr == null) {
            return Constants.MAGIC_CHECKSUM;
        }
        return TOSUtils.parseChecksumStringToBytes(checksumStr, type);
    }

    public static byte[] parseChecksum(GetFileStatusOutput obj, ChecksumInfo checksumInfo) {
        ChecksumType type = checksumInfo.checksumType();
        if (type == ChecksumType.CRC32C) {
            return TOSUtils.parseChecksumStringToBytes(obj.getCrc32(), type);
        }
        if (type == ChecksumType.CRC64ECMA) {
            return TOSUtils.parseChecksumStringToBytes(obj.getCrc64(), type);
        }
        throw new IllegalArgumentException(String.format("Checksum type %s is not supported by TOS.", type.name()));
    }

    public static byte[] parseChecksumStringToBytes(String checksum, ChecksumType type) {
        if (checksum == null) {
            return Constants.MAGIC_CHECKSUM;
        }
        switch (type) {
            case CRC32C: 
            case CRC64ECMA: {
                return Bytes.toBytes(Long.parseUnsignedLong(checksum));
            }
        }
        throw new IllegalArgumentException(String.format("Checksum type %s is not supported by TOS.", type.name()));
    }

    public static String crc64ecma(Map<String, String> headers) {
        String header = CHECKSUM_HEADER.get((Object)ChecksumType.CRC64ECMA);
        return headers.get(header);
    }

    public static boolean appendable(Map<String, String> headers) {
        String value = headers.get(OBJECT_TYPE_KEY);
        return APPENDABLE_TYPE_VALUE.equals(value);
    }
}

