/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.tosfs.object.tos.GetObjectOutput;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;
import org.apache.hadoop.thirdparty.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TOSInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TOSInputStream.class);
    private final GetObjectOutput output;
    private final InputStream stream;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private long curOff;
    private final long endOff;
    private final long maxDrainByteSize;

    TOSInputStream(GetObjectOutput output, long startOff, long endOff, long maxDrainByteSize, byte[] expectedChecksum) throws IOException {
        this.output = output;
        this.stream = output.verifiedContent(expectedChecksum);
        this.curOff = startOff;
        this.endOff = endOff;
        this.maxDrainByteSize = maxDrainByteSize;
    }

    @Override
    public int read() throws IOException {
        int b = this.stream.read();
        ++this.curOff;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        int readed = 0;
        do {
            if ((n = this.stream.read(b, off + readed, len - readed)) <= 0) continue;
            readed += n;
        } while (n > 0);
        if (readed == 0) {
            return n;
        }
        this.curOff += (long)readed;
        return readed;
    }

    GetObjectOutput getObjectOutput() {
        return this.output;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            if (this.endOff >= 0L) {
                long gap = this.endOff - this.curOff + 1L;
                if (gap <= this.maxDrainByteSize) {
                    this.stream.close();
                } else {
                    CommonUtils.runQuietly(this.output::forceClose, false);
                }
            } else {
                try {
                    ByteStreams.skipFully((InputStream)this.stream, (long)this.maxDrainByteSize);
                }
                catch (Exception e) {
                    if (e instanceof EOFException) {
                        LOG.debug("Stream is EOF now, just close the stream to reuse the socket connection.");
                        this.stream.close();
                    } else {
                        LOG.debug("Stream skipFully encountered exception, force close the socket connection.", (Throwable)e);
                        CommonUtils.runQuietly(this.output::forceClose, false);
                    }
                    return;
                }
                CommonUtils.runQuietly(this.output::forceClose, false);
            }
        }
    }
}

