/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos;

import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.comm.common.ACLType;
import com.volcengine.tos.comm.common.BucketType;
import com.volcengine.tos.internal.util.TypeConverter;
import com.volcengine.tos.model.bucket.HeadBucketV2Input;
import com.volcengine.tos.model.bucket.HeadBucketV2Output;
import com.volcengine.tos.model.bucket.Tag;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AppendObjectOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.DeleteError;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectTaggingInput;
import com.volcengine.tos.model.object.GetFileStatusInput;
import com.volcengine.tos.model.object.GetFileStatusOutput;
import com.volcengine.tos.model.object.GetObjectBasicOutput;
import com.volcengine.tos.model.object.GetObjectTaggingInput;
import com.volcengine.tos.model.object.GetObjectTaggingOutput;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Input;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Output;
import com.volcengine.tos.model.object.ListObjectsType2Input;
import com.volcengine.tos.model.object.ListObjectsType2Output;
import com.volcengine.tos.model.object.ListedCommonPrefix;
import com.volcengine.tos.model.object.ListedObjectV2;
import com.volcengine.tos.model.object.ListedUpload;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.ObjectTobeDeleted;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.PutObjectTaggingInput;
import com.volcengine.tos.model.object.RenameObjectInput;
import com.volcengine.tos.model.object.TagSet;
import com.volcengine.tos.model.object.UploadPartCopyV2Input;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadedPartV2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.conf.ConfKeys;
import org.apache.hadoop.fs.tosfs.conf.TosKeys;
import org.apache.hadoop.fs.tosfs.object.BucketInfo;
import org.apache.hadoop.fs.tosfs.object.ChecksumInfo;
import org.apache.hadoop.fs.tosfs.object.ChecksumType;
import org.apache.hadoop.fs.tosfs.object.Constants;
import org.apache.hadoop.fs.tosfs.object.DirectoryStorage;
import org.apache.hadoop.fs.tosfs.object.InputStreamProvider;
import org.apache.hadoop.fs.tosfs.object.MultipartUpload;
import org.apache.hadoop.fs.tosfs.object.ObjectContent;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.fs.tosfs.object.ObjectUtils;
import org.apache.hadoop.fs.tosfs.object.Part;
import org.apache.hadoop.fs.tosfs.object.exceptions.InvalidObjectKeyException;
import org.apache.hadoop.fs.tosfs.object.exceptions.NotAppendableException;
import org.apache.hadoop.fs.tosfs.object.request.ListObjectsRequest;
import org.apache.hadoop.fs.tosfs.object.response.ListObjectsResponse;
import org.apache.hadoop.fs.tosfs.object.tos.ChainTOSInputStream;
import org.apache.hadoop.fs.tosfs.object.tos.DelegationClient;
import org.apache.hadoop.fs.tosfs.object.tos.DelegationClientBuilder;
import org.apache.hadoop.fs.tosfs.object.tos.GetObjectOutput;
import org.apache.hadoop.fs.tosfs.object.tos.TOSUtils;
import org.apache.hadoop.fs.tosfs.object.tos.TosObjectInfo;
import org.apache.hadoop.fs.tosfs.util.LazyReload;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOS
implements DirectoryStorage {
    private static final Logger LOG = LoggerFactory.getLogger(TOS.class);
    public static final String TOS_SCHEME = "tos";
    public static final String ENV_TOS_ACCESS_KEY_ID = "TOS_ACCESS_KEY_ID";
    public static final String ENV_TOS_SECRET_ACCESS_KEY = "TOS_SECRET_ACCESS_KEY";
    public static final String ENV_TOS_SESSION_TOKEN = "TOS_SESSION_TOKEN";
    public static final String ENV_TOS_ENDPOINT = "TOS_ENDPOINT";
    private static final int NOT_FOUND_CODE = 404;
    private static final int PATH_CONFLICT_CODE = 409;
    private static final int INVALID_RANGE_CODE = 416;
    private static final int MIN_PART_SIZE = 0x500000;
    private static final int MAX_PART_COUNT = 10000;
    private static final InputStream EMPTY_STREAM = new ByteArrayInputStream(new byte[0]);
    private Configuration conf;
    private String bucket;
    private DelegationClient client;
    private long maxDrainBytes;
    private int batchDeleteMaxRetries;
    private List<String> batchDeleteRetryCodes;
    private long batchDeleteRetryInterval;
    private int maxDeleteObjectsCount;
    private int listObjectsCount;
    private int maxInputStreamRetries;
    private ACLType defaultAcl;
    private ChecksumInfo checksumInfo;
    private BucketInfo bucketInfo;

    @Override
    public void initialize(Configuration config, String bucketName) {
        this.conf = config;
        this.bucket = bucketName;
        this.client = new DelegationClientBuilder().conf(config).bucket(bucketName).build();
        this.maxDrainBytes = config.getLong("fs.tos.max-drain-bytes", 0x100000L);
        this.batchDeleteMaxRetries = config.getInt("fs.tos.batch.delete.max-retries", 20);
        this.batchDeleteRetryCodes = Arrays.asList(config.getTrimmedStrings("fs.tos.batch.delete.retry-codes", TosKeys.FS_TOS_BATCH_DELETE_RETRY_CODES_DEFAULT));
        this.batchDeleteRetryInterval = config.getLong("fs.tos.batch.delete.retry.interval", 1000L);
        this.maxDeleteObjectsCount = config.getInt("fs.tos.batch.delete.objects-count", 1000);
        this.listObjectsCount = config.getInt("fs.tos.list.objects-count", 1000);
        this.maxInputStreamRetries = config.getInt("fs.tos.inputstream.max.retry.times", 5);
        this.defaultAcl = TypeConverter.convertACLType(config.get("fs.tos.acl.default"));
        String algorithm = config.get("fs.tos.checksum-algorithm", "TOS-CHECKSUM");
        ChecksumType checksumType = ChecksumType.valueOf(config.get("fs.tos.checksum-type", TosKeys.FS_TOS_CHECKSUM_TYPE_DEFAULT).toUpperCase());
        Preconditions.checkArgument((boolean)TOSUtils.CHECKSUM_HEADER.containsKey((Object)checksumType), (String)"Checksum type %s is not supported by TOS.", (Object[])new Object[]{checksumType.name()});
        this.checksumInfo = new ChecksumInfo(algorithm, checksumType);
        this.bucketInfo = this.getBucketInfo(bucketName);
    }

    @Override
    public String scheme() {
        return TOS_SCHEME;
    }

    @Override
    public Configuration conf() {
        return this.conf;
    }

    @Override
    public BucketInfo bucket() {
        return this.bucketInfo;
    }

    private BucketInfo getBucketInfo(String bucketName) {
        try {
            HeadBucketV2Output res = this.client.headBucket(HeadBucketV2Input.builder().bucket(bucketName).build());
            boolean directoryBucket = BucketType.BUCKET_TYPE_HNS.equals((Object)res.getBucketType());
            return new BucketInfo(bucketName, directoryBucket);
        }
        catch (TosException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    void setClient(DelegationClient client) {
        this.client = client;
    }

    private void checkAvailableClient() {
        Preconditions.checkState((this.client != null ? 1 : 0) != 0, (Object)"Encountered uninitialized ObjectStorage, call initialize(..) please.");
    }

    @Override
    public ObjectContent get(String key, long offset, long limit) {
        this.checkAvailableClient();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset is a negative number: %s", (Object[])new Object[]{offset});
        if (limit == 0L) {
            if (this.head(key) != null) {
                return new ObjectContent(Constants.MAGIC_CHECKSUM, EMPTY_STREAM);
            }
            throw new RuntimeException(String.format("Object %s doesn't exit", key));
        }
        long end = limit < 0L ? -1L : offset + limit - 1L;
        GetObjectFactory factory = (k, startOff, endOff) -> this.getObject(key, startOff, endOff);
        ChainTOSInputStream chainStream = new ChainTOSInputStream(factory, key, offset, end, this.maxDrainBytes, this.maxInputStreamRetries);
        return new ObjectContent(chainStream.checksum(), chainStream);
    }

    @Override
    public Iterable<ObjectInfo> listDir(String key, boolean recursive) {
        if (recursive) {
            if (this.bucket().isDirectory()) {
                return this.bfsListDir(key);
            }
            return this.listAll(key, key);
        }
        return this.innerListDir(key, key, -1);
    }

    private Iterable<ObjectInfo> bfsListDir(String key) {
        return new LazyReload<ObjectInfo>(() -> {
            LinkedList dirQueue = new LinkedList();
            AtomicReference<String> continueToken = new AtomicReference<String>("");
            AtomicReference<String> curDir = new AtomicReference<String>(key);
            return buf -> {
                if (curDir.get() == null) {
                    return true;
                }
                ListObjectsType2Input request = this.createListObjectsType2Input((String)curDir.get(), (String)curDir.get(), this.listObjectsCount, "/", (String)continueToken.get());
                ListObjectsType2Output response = this.client.listObjectsType2(request);
                if (response.getContents() != null) {
                    for (ListedObjectV2 obj : response.getContents()) {
                        buf.add(new ObjectInfo(obj.getKey(), obj.getSize(), obj.getLastModified(), TOSUtils.parseChecksum(obj, this.checksumInfo)));
                    }
                }
                if (response.getCommonPrefixes() != null) {
                    for (ListedCommonPrefix prefix : response.getCommonPrefixes()) {
                        buf.add(new ObjectInfo(prefix.getPrefix(), 0L, new Date(), Constants.MAGIC_CHECKSUM));
                        dirQueue.add(prefix.getPrefix());
                    }
                }
                if (response.isTruncated()) {
                    continueToken.set(response.getNextContinuationToken());
                } else {
                    curDir.set((String)dirQueue.poll());
                    continueToken.set("");
                }
                return curDir.get() == null;
            };
        });
    }

    private Iterable<ObjectInfo> innerListDir(String key, String startAfter, int limit) {
        return new LazyReload<ObjectInfo>(() -> {
            AtomicReference<String> continueToken = new AtomicReference<String>("");
            AtomicBoolean isTruncated = new AtomicBoolean(true);
            AtomicInteger remaining = new AtomicInteger(limit < 0 ? Integer.MAX_VALUE : limit);
            return buf -> {
                if (!isTruncated.get()) {
                    return true;
                }
                int remainingKeys = remaining.get();
                int maxKeys = Math.min(this.listObjectsCount, remainingKeys);
                ListObjectsType2Input request = this.createListObjectsType2Input(key, startAfter, maxKeys, "/", (String)continueToken.get());
                ListObjectsType2Output response = this.client.listObjectsType2(request);
                if (response.getContents() != null) {
                    for (ListedObjectV2 obj : response.getContents()) {
                        buf.add(new ObjectInfo(obj.getKey(), obj.getSize(), obj.getLastModified(), TOSUtils.parseChecksum(obj, this.checksumInfo)));
                    }
                }
                if (response.getCommonPrefixes() != null) {
                    for (ListedCommonPrefix prefix : response.getCommonPrefixes()) {
                        buf.add(new ObjectInfo(prefix.getPrefix(), 0L, new Date(), Constants.MAGIC_CHECKSUM));
                    }
                }
                isTruncated.set(response.isTruncated());
                remaining.compareAndSet(remainingKeys, remainingKeys - response.getKeyCount());
                continueToken.set(response.getNextContinuationToken());
                return !isTruncated.get();
            };
        });
    }

    @Override
    public void deleteDir(String key, boolean recursive) {
        this.checkAvailableClient();
        if (recursive) {
            if (this.conf.getBoolean("fs.tos.rmr.server.enabled", false)) {
                DeleteObjectInput request = DeleteObjectInput.builder().bucket(this.bucket).recursive(true).key(key).build();
                try {
                    Field f = DeleteObjectInput.class.getDeclaredField("recursiveByServer");
                    f.setAccessible(true);
                    f.setBoolean(request, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.client.deleteObject(request);
            } else if (this.conf.getBoolean("fs.tos.rmr.client.enabled", true)) {
                this.client.deleteObject(DeleteObjectInput.builder().bucket(this.bucket).recursive(true).key(key).build());
            } else {
                this.recursiveDeleteDir(key);
            }
        } else {
            this.delete(key);
        }
    }

    @Override
    public boolean isEmptyDir(String key) {
        this.checkAvailableClient();
        return !this.innerListDir(key, key, 1).iterator().hasNext();
    }

    public void recursiveDeleteDir(String key) {
        for (ObjectInfo obj : this.innerListDir(key, key, -1)) {
            if (obj.isDir()) {
                this.recursiveDeleteDir(obj.key());
                continue;
            }
            this.delete(obj.key());
        }
        this.delete(key);
    }

    public GetObjectOutput getObject(String key, long offset, long end) {
        this.checkAvailableClient();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset is a negative number: %s", (Object[])new Object[]{offset});
        try {
            GetObjectV2Input request = GetObjectV2Input.builder().bucket(this.bucket).key(key).options(ObjectMetaRequestOptions.builder().range(offset, end).build()).build();
            GetObjectV2Output output = this.client.getObject(request);
            byte[] checksum = TOSUtils.parseChecksum(output.getRequestInfo().getHeader(), this.checksumInfo);
            return new GetObjectOutput(output, checksum);
        }
        catch (TosException e) {
            TosServerException tosException;
            if (e instanceof TosServerException && (tosException = (TosServerException)e).getStatusCode() == 416) {
                ObjectInfo info = this.head(key);
                if (info.size() == 0L || offset == info.size()) {
                    return new GetObjectOutput(new GetObjectV2Output(new GetObjectBasicOutput(), EMPTY_STREAM), info.checksum());
                }
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] put(String key, InputStreamProvider streamProvider, long contentLength) {
        this.checkAvailableClient();
        PutObjectOutput res = this.client.put(this.bucket, key, streamProvider, contentLength, this.defaultAcl);
        return ObjectInfo.isDir(key) ? Constants.MAGIC_CHECKSUM : TOSUtils.parseChecksum(res.getRequestInfo().getHeader(), this.checksumInfo);
    }

    @Override
    public byte[] append(String key, InputStreamProvider streamProvider, long contentLength) {
        if (this.bucketInfo.isDirectory()) {
            return this.hnsAppend(key, streamProvider, contentLength);
        }
        return this.fnsAppend(key, streamProvider, contentLength);
    }

    private byte[] hnsAppend(String key, InputStreamProvider streamProvider, long contentLength) {
        String preCrc64;
        Object res;
        this.checkAvailableClient();
        long offset = 0L;
        TosObjectInfo obj = this.innerHead(key);
        if (obj == null) {
            if (contentLength == 0L) {
                throw new NotAppendableException(String.format("%s is not appendable because append non-existed object with zero byte is not supported.", key));
            }
            res = this.client.put(this.bucket, key, () -> EMPTY_STREAM, 0L, this.defaultAcl);
            preCrc64 = ((PutObjectOutput)res).getHashCrc64ecma();
        } else {
            if (contentLength == 0L) {
                return obj.checksum();
            }
            offset = obj.size();
            preCrc64 = obj.crc64ecma();
        }
        res = this.client.appendObject(this.bucket, key, streamProvider, offset, contentLength, preCrc64, this.defaultAcl);
        return ObjectInfo.isDir(key) ? Constants.MAGIC_CHECKSUM : TOSUtils.parseChecksum(((AppendObjectOutput)res).getRequestInfo().getHeader(), this.checksumInfo);
    }

    private byte[] fnsAppend(String key, InputStreamProvider streamProvider, long contentLength) {
        AppendObjectOutput res;
        this.checkAvailableClient();
        TosObjectInfo obj = this.innerHead(key);
        if (obj != null) {
            if (!obj.appendable()) {
                throw new NotAppendableException(String.format("%s is not appendable.", key));
            }
            if (contentLength == 0L) {
                return obj.checksum();
            }
        } else if (contentLength == 0L) {
            throw new NotAppendableException(String.format("%s is not appendable because append non-existed object with zero byte is not supported.", key));
        }
        long offset = obj == null ? 0L : obj.size();
        String preCrc64 = obj == null ? null : obj.crc64ecma();
        try {
            res = this.client.appendObject(this.bucket, key, streamProvider, offset, contentLength, preCrc64, this.defaultAcl);
        }
        catch (TosServerException e) {
            if (e.getStatusCode() == 409 && "0017-00000209".equals(e.getEc())) {
                throw new NotAppendableException(String.format("%s is not appendable.", key));
            }
            throw e;
        }
        return ObjectInfo.isDir(key) ? Constants.MAGIC_CHECKSUM : TOSUtils.parseChecksum(res.getRequestInfo().getHeader(), this.checksumInfo);
    }

    @Override
    public void delete(String key) {
        this.checkAvailableClient();
        this.client.deleteObject(DeleteObjectInput.builder().bucket(this.bucket).key(key).build());
    }

    @Override
    public List<String> batchDelete(List<String> keys) {
        this.checkAvailableClient();
        int totalKeyCnt = keys.size();
        Preconditions.checkArgument((totalKeyCnt <= this.maxDeleteObjectsCount ? 1 : 0) != 0, (String)"The batch delete object count should <= %s", (Object[])new Object[]{this.maxDeleteObjectsCount});
        List<DeleteError> failedKeys = this.innerBatchDelete(keys);
        for (int retry = 1; retry < this.batchDeleteMaxRetries && !failedKeys.isEmpty(); ++retry) {
            if (this.isBatchDeleteRetryable(failedKeys)) {
                try {
                    Thread.sleep(this.batchDeleteRetryInterval);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                LOG.warn("{} of {} objects deleted failed, and cannot be retried, detail: {}", new Object[]{failedKeys.size(), totalKeyCnt, Joiner.on((String)",\n").join(failedKeys)});
                break;
            }
            failedKeys = this.innerBatchDelete(TOS.deleteErrorKeys(failedKeys));
        }
        if (!failedKeys.isEmpty()) {
            LOG.warn("{} of {} objects deleted failed after retry {} times.", new Object[]{failedKeys.size(), totalKeyCnt, this.batchDeleteMaxRetries});
        }
        return TOS.deleteErrorKeys(failedKeys);
    }

    @Override
    public void deleteAll(String prefix) {
        if (this.bucket().isDirectory()) {
            this.deleteDir(prefix, true);
        } else {
            Iterable<ObjectInfo> objects = this.listAll(prefix, "");
            ObjectUtils.deleteAllObjects(this, objects, this.conf.getInt(ConfKeys.FS_BATCH_DELETE_SIZE.key(this.scheme()), 250));
        }
    }

    private List<DeleteError> innerBatchDelete(List<String> keys) {
        ArrayList toBeDeleted = Lists.newArrayList();
        for (String key : keys) {
            toBeDeleted.add(ObjectTobeDeleted.builder().key(key).build());
        }
        DeleteMultiObjectsV2Output deletedRes = this.client.deleteMultiObjects(DeleteMultiObjectsV2Input.builder().bucket(this.bucket).objects(toBeDeleted).build());
        return deletedRes.getErrors() == null ? Lists.newArrayList() : deletedRes.getErrors();
    }

    private boolean isBatchDeleteRetryable(List<DeleteError> failedKeys) {
        for (DeleteError errorKey : failedKeys) {
            if (this.batchDeleteRetryCodes.contains(errorKey.getCode())) {
                LOG.warn("Failed to delete object, which might be deleted succeed after retry, detail: {}", (Object)errorKey);
                continue;
            }
            return false;
        }
        return true;
    }

    private static List<String> deleteErrorKeys(List<DeleteError> errorKeys) {
        ArrayList keys = Lists.newArrayList();
        for (DeleteError error : errorKeys) {
            keys.add(error.getKey());
        }
        return keys;
    }

    @Override
    public ObjectInfo head(String key) {
        return this.innerHead(key);
    }

    private TosObjectInfo innerHead(String key) {
        this.checkAvailableClient();
        try {
            HeadObjectV2Input request = HeadObjectV2Input.builder().bucket(this.bucket).key(key).build();
            HeadObjectV2Output response = this.client.headObject(request);
            Map<String, String> headers = response.getRequestInfo().getHeader();
            byte[] checksum = TOSUtils.parseChecksum(headers, this.checksumInfo);
            boolean isDir = this.bucket().isDirectory() ? response.isDirectory() : ObjectInfo.isDir(key);
            return new TosObjectInfo(key, response.getContentLength(), response.getLastModifiedInDate(), checksum, isDir, TOSUtils.appendable(headers), TOSUtils.crc64ecma(headers));
        }
        catch (TosException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            if (e.getStatusCode() == 409) {
                throw new InvalidObjectKeyException(e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<ListObjectsResponse> list(ListObjectsRequest req) {
        return new LazyReload<ListObjectsResponse>(() -> {
            AtomicReference<String> continueToken = new AtomicReference<String>("");
            AtomicBoolean isTruncated = new AtomicBoolean(true);
            AtomicInteger remaining = new AtomicInteger(req.maxKeys() < 0 ? Integer.MAX_VALUE : req.maxKeys());
            return buf -> {
                if (!isTruncated.get()) {
                    return true;
                }
                int remainingKeys = remaining.get();
                int maxKeys = Math.min(this.listObjectsCount, remainingKeys);
                ListObjectsType2Input request = this.createListObjectsType2Input(req.prefix(), req.startAfter(), maxKeys, req.delimiter(), (String)continueToken.get());
                ListObjectsType2Output response = this.client.listObjectsType2(request);
                List<ObjectInfo> objects = this.listObjectsOutputToObjectInfos(response);
                List<String> commonPrefixes = this.listObjectsOutputToCommonPrefixes(response);
                buf.add(new ListObjectsResponse(objects, commonPrefixes));
                if (maxKeys < this.listObjectsCount) {
                    isTruncated.set(false);
                } else {
                    continueToken.set(response.getNextContinuationToken());
                    remaining.compareAndSet(remainingKeys, remainingKeys - response.getKeyCount());
                    if (remaining.get() == 0) {
                        isTruncated.set(false);
                    } else {
                        isTruncated.set(response.isTruncated());
                    }
                }
                return !isTruncated.get();
            };
        });
    }

    private List<String> listObjectsOutputToCommonPrefixes(ListObjectsType2Output listObjectsOutput) {
        if (listObjectsOutput.getCommonPrefixes() == null) {
            return Lists.newArrayList();
        }
        return listObjectsOutput.getCommonPrefixes().stream().map(ListedCommonPrefix::getPrefix).collect(Collectors.toList());
    }

    private List<ObjectInfo> listObjectsOutputToObjectInfos(ListObjectsType2Output listObjectsOutput) {
        if (listObjectsOutput.getContents() == null) {
            return Lists.newArrayList();
        }
        return listObjectsOutput.getContents().stream().map(obj -> new ObjectInfo(obj.getKey(), obj.getSize(), obj.getLastModified(), TOSUtils.parseChecksum(obj, this.checksumInfo))).collect(Collectors.toList());
    }

    private ListObjectsType2Input createListObjectsType2Input(String prefix, String startAfter, int maxKeys, String delimiter, String continueToken) {
        ListObjectsType2Input.ListObjectsType2InputBuilder builder = ListObjectsType2Input.builder().bucket(this.bucket).prefix(prefix).startAfter(startAfter).delimiter(delimiter).maxKeys(maxKeys);
        if (!Strings.isNullOrEmpty((String)continueToken)) {
            builder.continuationToken(continueToken);
        }
        return builder.build();
    }

    @Override
    public MultipartUpload createMultipartUpload(String key) {
        this.checkAvailableClient();
        CreateMultipartUploadInput input = CreateMultipartUploadInput.builder().bucket(this.bucket).key(key).options(this.createMetaOptions()).build();
        CreateMultipartUploadOutput output = this.client.createMultipartUpload(input);
        return new MultipartUpload(output.getKey(), output.getUploadID(), 0x500000, 10000);
    }

    @Override
    public Part uploadPart(String key, String uploadId, int partNum, InputStreamProvider streamProvider, long contentLength) {
        this.checkAvailableClient();
        return this.client.uploadPart(this.bucket, key, uploadId, partNum, streamProvider, contentLength, this.defaultAcl);
    }

    @Override
    public byte[] completeUpload(String key, String uploadId, List<Part> uploadParts) {
        this.checkAvailableClient();
        List<UploadedPartV2> uploadedPartsV2 = uploadParts.stream().map(part -> UploadedPartV2.builder().etag(part.eTag()).partNumber(part.num()).size(part.size()).build()).collect(Collectors.toList());
        CompleteMultipartUploadV2Input input = CompleteMultipartUploadV2Input.builder().bucket(this.bucket).key(key).uploadID(uploadId).uploadedParts(uploadedPartsV2).build();
        return TOSUtils.parseChecksum(this.client.completeMultipartUpload(input).getRequestInfo().getHeader(), this.checksumInfo);
    }

    @Override
    public void abortMultipartUpload(String key, String uploadId) {
        this.checkAvailableClient();
        AbortMultipartUploadInput input = AbortMultipartUploadInput.builder().bucket(this.bucket).key(key).uploadID(uploadId).build();
        this.client.abortMultipartUpload(input);
    }

    @Override
    public Iterable<MultipartUpload> listUploads(String prefix) {
        this.checkAvailableClient();
        return new LazyReload<MultipartUpload>(() -> {
            AtomicReference<String> nextKeyMarker = new AtomicReference<String>("");
            AtomicReference<String> nextUploadIdMarker = new AtomicReference<String>("");
            AtomicBoolean isTruncated = new AtomicBoolean(true);
            return buf -> {
                if (!isTruncated.get()) {
                    return true;
                }
                ListMultipartUploadsV2Input input = ListMultipartUploadsV2Input.builder().bucket(this.bucket).prefix(prefix).keyMarker((String)nextKeyMarker.get()).uploadIDMarker((String)nextUploadIdMarker.get()).build();
                ListMultipartUploadsV2Output output = this.client.listMultipartUploads(input);
                isTruncated.set(output.isTruncated());
                if (output.getUploads() != null) {
                    for (ListedUpload upload : output.getUploads()) {
                        buf.add(new MultipartUpload(upload.getKey(), upload.getUploadID(), 0x500000, 10000));
                    }
                    LOG.info("Retrieve {} uploads with prefix: {}, marker: {}", new Object[]{output.getUploads().size(), nextKeyMarker.get(), nextUploadIdMarker.get()});
                }
                nextKeyMarker.set(output.getNextKeyMarker());
                nextUploadIdMarker.set(output.getNextUploadIdMarker());
                return !isTruncated.get();
            };
        });
    }

    @Override
    public Part uploadPartCopy(String srcKey, String dstKey, String uploadId, int partNum, long copySourceRangeStart, long copySourceRangeEnd) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)srcKey) ? 1 : 0) != 0, (Object)"Source key should not be empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dstKey) ? 1 : 0) != 0, (Object)"Dest key should not be empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uploadId) ? 1 : 0) != 0, (Object)"Upload ID should not be empty.");
        Preconditions.checkArgument((copySourceRangeStart >= 0L ? 1 : 0) != 0, (Object)"CopySourceRangeStart must be >= 0.");
        Preconditions.checkArgument((copySourceRangeEnd >= 0L ? 1 : 0) != 0, (Object)"CopySourceRangeEnd must be >= 0.");
        Preconditions.checkNotNull((Object)(copySourceRangeEnd >= copySourceRangeStart ? 1 : 0), (Object)"CopySourceRangeEnd must be >= copySourceRangeStart.");
        this.checkAvailableClient();
        UploadPartCopyV2Input input = UploadPartCopyV2Input.builder().bucket(this.bucket).key(dstKey).uploadID(uploadId).sourceBucket(this.bucket).sourceKey(srcKey).partNumber(partNum).copySourceRange(copySourceRangeStart, copySourceRangeEnd).options(this.createMetaOptions()).build();
        UploadPartCopyV2Output output = this.client.uploadPartCopy(input);
        return new Part(output.getPartNumber(), copySourceRangeEnd - copySourceRangeStart + 1L, output.getEtag());
    }

    @Override
    public void copy(String srcKey, String dstKey) {
        this.checkAvailableClient();
        CopyObjectV2Input input = CopyObjectV2Input.builder().bucket(this.bucket).key(dstKey).srcBucket(this.bucket).srcKey(srcKey).options(this.createMetaOptions()).build();
        this.client.copyObject(input);
    }

    private ObjectMetaRequestOptions createMetaOptions() {
        return new ObjectMetaRequestOptions().setAclType(this.defaultAcl);
    }

    @Override
    public void rename(String srcKey, String dstKey) {
        this.checkAvailableClient();
        Preconditions.checkArgument((!Objects.equals(srcKey, dstKey) ? 1 : 0) != 0, (Object)"Cannot rename to the same object");
        RenameObjectInput request = RenameObjectInput.builder().bucket(this.bucket).key(srcKey).newKey(dstKey).build();
        this.client.renameObject(request);
    }

    @Override
    public void putTags(String key, Map<String, String> newTags) {
        this.checkAvailableClient();
        List<Tag> tags = newTags.entrySet().stream().map(e -> new Tag().setKey((String)e.getKey()).setValue((String)e.getValue())).collect(Collectors.toList());
        if (tags.size() > 0) {
            this.client.putObjectTagging(TOS.createPutTagInput(this.bucket, key, tags));
        } else {
            this.client.deleteObjectTagging(TOS.createDeleteTagInput(this.bucket, key));
        }
    }

    @Override
    public Map<String, String> getTags(String key) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Tag tag : this.getObjectTaggingList(key)) {
            result.put(tag.getKey(), tag.getValue());
        }
        return result;
    }

    private List<Tag> getObjectTaggingList(String key) {
        this.checkAvailableClient();
        GetObjectTaggingInput input = GetObjectTaggingInput.builder().bucket(this.bucket).key(key).build();
        GetObjectTaggingOutput output = this.client.getObjectTagging(input);
        TagSet tagSet = output.getTagSet();
        if (tagSet == null || tagSet.getTags() == null) {
            return new ArrayList<Tag>();
        }
        return tagSet.getTags();
    }

    private static PutObjectTaggingInput createPutTagInput(String bucket, String key, List<Tag> tags) {
        return PutObjectTaggingInput.builder().bucket(bucket).key(key).tagSet(TagSet.builder().tags(tags).build()).build();
    }

    private static DeleteObjectTaggingInput createDeleteTagInput(String bucket, String key) {
        return DeleteObjectTaggingInput.builder().bucket(bucket).key(key).build();
    }

    private ObjectInfo getFileStatus(String key) {
        this.checkAvailableClient();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"key should not be empty.");
        GetFileStatusInput input = GetFileStatusInput.builder().bucket(this.bucket).key(key).build();
        try {
            GetFileStatusOutput output = this.client.getFileStatus(input);
            if (key.equals(output.getKey()) && !ObjectInfo.isDir(output.getKey())) {
                return new ObjectInfo(key, output.getSize(), output.getLastModifiedInDate(), TOSUtils.parseChecksum(output, this.checksumInfo));
            }
            Object dirKey = ObjectInfo.isDir(key) ? key : key + "/";
            Date lastModifiedInDate = ((String)dirKey).equals(output.getKey()) ? output.getLastModifiedInDate() : new Date();
            return new ObjectInfo((String)dirKey, 0L, lastModifiedInDate, Constants.MAGIC_CHECKSUM, true);
        }
        catch (TosException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            if (e.getStatusCode() == 409) {
                throw new InvalidObjectKeyException(e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectInfo objectStatus(String key) {
        Iterable<ObjectInfo> objs;
        if (this.bucket().isDirectory()) {
            return this.head((String)key);
        }
        if (this.conf.getBoolean("fs.tos.get-file-status.enabled", true)) {
            return this.getFileStatus((String)key);
        }
        ObjectInfo obj = this.head((String)key);
        if (obj == null && !ObjectInfo.isDir((String)key)) {
            key = (String)key + "/";
            obj = this.head((String)key);
        }
        if (obj == null && (objs = this.list((String)key, null, 1)).iterator().hasNext()) {
            obj = new ObjectInfo((String)key, 0L, new Date(0L), Constants.MAGIC_CHECKSUM, true);
        }
        return obj;
    }

    @Override
    public ChecksumInfo checksumInfo() {
        return this.checksumInfo;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    static {
        org.apache.log4j.Logger logger = LogManager.getLogger((String)"com.volcengine.tos");
        String logLevel = System.getProperty("tos.log.level", "WARN");
        LOG.debug("Reset the log level of com.volcengine.tos with {} ", (Object)logLevel);
        logger.setLevel(Level.toLevel((String)logLevel.toUpperCase(), (Level)Level.WARN));
    }

    static interface GetObjectFactory {
        public GetObjectOutput create(String var1, long var2, long var4);
    }
}

