/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos;

import com.volcengine.tos.model.object.GetObjectV2Output;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.tosfs.object.exceptions.ChecksumMismatchException;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;
import org.apache.hadoop.util.Preconditions;

public class GetObjectOutput {
    private final GetObjectV2Output output;
    private final byte[] checksum;

    public GetObjectOutput(GetObjectV2Output output, byte[] checksum) {
        Preconditions.checkNotNull((Object)checksum, (Object)"Checksum should not be null.");
        this.output = output;
        this.checksum = checksum;
    }

    public GetObjectV2Output output() {
        return this.output;
    }

    public byte[] checksum() {
        return this.checksum;
    }

    public InputStream verifiedContent(byte[] expectedChecksum) throws IOException {
        if (!Arrays.equals(expectedChecksum, this.checksum)) {
            CommonUtils.runQuietly(this::forceClose);
            throw new ChecksumMismatchException(expectedChecksum, this.checksum);
        }
        return this.output.getContent();
    }

    public void forceClose() throws IOException {
        this.output.forceClose();
    }
}

