/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos;

import com.volcengine.tos.TOSClientConfiguration;
import com.volcengine.tos.TosException;
import com.volcengine.tos.transport.TransportConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.conf.ConfKeys;
import org.apache.hadoop.fs.tosfs.conf.TosKeys;
import org.apache.hadoop.fs.tosfs.object.tos.DelegationClient;
import org.apache.hadoop.fs.tosfs.object.tos.auth.CredentialsProvider;
import org.apache.hadoop.fs.tosfs.util.ParseUtils;
import org.apache.hadoop.fs.tosfs.util.TOSClientContextUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.VersionInfo;

public class DelegationClientBuilder {
    public static final int DISABLE_TOS_RETRY_VALUE = -1;
    private static final String TOS_ENDPOINT_KEY = ConfKeys.FS_OBJECT_STORAGE_ENDPOINT.key("tos");
    private static final String TOS_REGION_KEY = ConfKeys.FS_OBJECT_STORAGE_REGION.key("tos");
    @VisibleForTesting
    static final Map<String, DelegationClient> CACHE = new ConcurrentHashMap<String, DelegationClient>();
    private String bucket;
    private Configuration conf;

    public DelegationClientBuilder bucket(String bucketInput) {
        this.bucket = bucketInput;
        return this;
    }

    public DelegationClientBuilder conf(Configuration confInput) {
        this.conf = confInput;
        return this;
    }

    public DelegationClient build() throws TosException {
        Preconditions.checkNotNull((Object)this.bucket, (Object)"Bucket cannot be null");
        Preconditions.checkNotNull((Object)this.conf, (Object)"Conf cannot be null");
        String endpoint = this.getAndCheckEndpoint(this.conf);
        String region = this.getAndCheckRegion(this.conf, endpoint);
        if (this.conf.getBoolean("fs.tos.client.disable.cache", false)) {
            return this.createNewClient(this.conf, endpoint, region, this.bucket, false);
        }
        return CACHE.computeIfAbsent(this.bucket, client -> this.createNewClient(this.conf, endpoint, region, this.bucket, true));
    }

    private DelegationClient createNewClient(Configuration config, String endpoint, String region, String bucketName, boolean cached) {
        CredentialsProvider provider = this.createProvider(config, bucketName);
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(provider).enableCrc(config.getBoolean("fs.tos.crc.check.enable", true)).transportConfig(this.createTransportConfig(config)).userAgentProductName(config.get("fs.tos.user.agent.prefix", "HADOOP-TOS")).userAgentSoftName("TOS_FS").userAgentSoftVersion(VersionInfo.getVersion()).build();
        int maxRetryTimes = config.getInt("fs.tos.request.max.retry.times", 20);
        List<String> nonRetryable409ErrorCodes = Arrays.asList(config.getTrimmedStrings("fs.tos.fast-fail-409-error-codes", new String[]{TosKeys.FS_TOS_FAST_FAILURE_409_ERROR_CODES_DEFAULT}));
        if (cached) {
            return new CachedClient(clientConfiguration, maxRetryTimes, nonRetryable409ErrorCodes);
        }
        return new DelegationClient(clientConfiguration, maxRetryTimes, nonRetryable409ErrorCodes);
    }

    private CredentialsProvider createProvider(Configuration config, String bucketName) {
        try {
            CredentialsProvider provider = (CredentialsProvider)Class.forName(config.get("fs.tos.credentials.provider", "org.apache.hadoop.fs.tosfs.object.tos.auth.DefaultCredentialsProviderChain")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            provider.initialize(config, bucketName);
            return provider;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TosException(e);
        }
    }

    private String getAndCheckEndpoint(Configuration config) {
        String endpoint = config.get(TOS_ENDPOINT_KEY);
        if (StringUtils.isBlank((CharSequence)endpoint)) {
            endpoint = ParseUtils.envAsString("TOS_ENDPOINT");
        }
        Preconditions.checkNotNull((Object)endpoint, (String)"%s cannot be null", (Object[])new Object[]{TOS_ENDPOINT_KEY});
        return endpoint.trim();
    }

    private String getAndCheckRegion(Configuration config, String endpoint) {
        String region = config.get(TOS_REGION_KEY);
        if (StringUtils.isNotBlank((CharSequence)region)) {
            return region.trim();
        }
        region = TOSClientContextUtils.parseRegion(endpoint);
        Preconditions.checkNotNull((Object)region, (String)"%s cannot be null", (Object[])new Object[]{TOS_REGION_KEY});
        return region.trim();
    }

    private TransportConfig createTransportConfig(Configuration config) {
        TransportConfig.TransportConfigBuilder builder = TransportConfig.builder();
        builder.maxRetryCount(-1);
        builder.maxConnections(config.getInt("fs.tos.http.maxConnections", 1024));
        builder.idleConnectionTimeMills(config.getInt("fs.tos.http.idleConnectionTimeMills", 60000));
        builder.connectTimeoutMills(config.getInt("fs.tos.http.connectTimeoutMills", 10000));
        builder.readTimeoutMills(config.getInt("fs.tos.http.readTimeoutMills", 30000));
        builder.writeTimeoutMills(config.getInt("fs.tos.http.writeTimeoutMills", 30000));
        builder.enableVerifySSL(config.getBoolean("fs.tos.http.enableVerifySSL", true));
        builder.dnsCacheTimeMinutes(config.getInt("fs.tos.http.dnsCacheTimeMinutes", 0));
        return builder.build();
    }

    static class CachedClient
    extends DelegationClient {
        protected CachedClient(TOSClientConfiguration configuration, int maxRetryTimes, List<String> nonRetryable409ErrorCodes) {
            super(configuration, maxRetryTimes, nonRetryable409ErrorCodes);
        }

        @Override
        public void close() {
        }
    }
}

