/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.tos;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.tosfs.common.Chain;
import org.apache.hadoop.fs.tosfs.object.tos.GetObjectOutput;
import org.apache.hadoop.fs.tosfs.object.tos.TOS;
import org.apache.hadoop.fs.tosfs.object.tos.TOSInputStream;
import org.apache.hadoop.util.Preconditions;

public class ChainTOSInputStream
extends InputStream {
    private final Chain<TOSInputStream> chain;
    private final TOS.GetObjectFactory factory;
    private final String key;
    private long curOff;
    private final long endOff;
    private final long maxDrainByteSize;
    private final int maxInputStreamRetries;
    private int readBytes;
    private long skipped;
    private byte[] objChecksum = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ChainTOSInputStream(TOS.GetObjectFactory factory, String key, long startOff, long endOff, long maxDrainByteSize, int maxInputStreamRetries) {
        this.factory = factory;
        this.key = key;
        this.curOff = startOff;
        this.endOff = endOff;
        this.maxDrainByteSize = maxDrainByteSize;
        this.maxInputStreamRetries = maxInputStreamRetries;
        this.chain = this.createChain();
        Preconditions.checkNotNull((Object)this.objChecksum, (Object)"Checksum should not be null.");
    }

    private Chain<TOSInputStream> createChain() {
        Chain.Builder<TOSInputStream> builder = Chain.builder().shouldContinue(e -> !(e instanceof EOFException));
        for (int i = 0; i <= this.maxInputStreamRetries; ++i) {
            builder.addLast(() -> {
                GetObjectOutput output = this.factory.create(this.key, this.curOff, this.endOff);
                if (this.objChecksum == null) {
                    this.objChecksum = output.checksum();
                }
                return new TOSInputStream(output, this.curOff, this.endOff, this.maxDrainByteSize, this.objChecksum);
            });
        }
        try {
            return builder.build();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.skipped = 0L;
        return this.chain.run(stream -> {
            long skip = stream.skip(n - this.skipped);
            this.curOff += skip;
            this.skipped += skip;
            return this.skipped;
        });
    }

    @Override
    public int read() throws IOException {
        return this.chain.run(stream -> {
            int ret = stream.read();
            ++this.curOff;
            return ret;
        });
    }

    @Override
    public int available() throws IOException {
        return this.chain.run(InputStream::available);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readBytes = 0;
        return this.chain.run(in -> {
            int read = in.read(b, off + this.readBytes, len - this.readBytes);
            this.readBytes += read;
            this.curOff += (long)read;
            return this.readBytes;
        });
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.chain.close();
        }
    }

    public byte[] checksum() {
        return this.objChecksum;
    }
}

