/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.staging;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.fs.tosfs.object.staging.StagingPart;
import org.apache.hadoop.fs.tosfs.object.staging.State;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStagingPart
implements StagingPart {
    private static final Logger LOG = LoggerFactory.getLogger(FileStagingPart.class);
    private final Path path;
    private final int stagingBufferSize;
    private final StagingFileOutputStream out;
    private State state = State.WRITABLE;

    public FileStagingPart(String filePath, int stagingBufferSize) {
        this.path = Paths.get(filePath, new String[0]);
        this.stagingBufferSize = stagingBufferSize;
        this.out = new StagingFileOutputStream(this.path, stagingBufferSize);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        Preconditions.checkState((this.state == State.WRITABLE ? 1 : 0) != 0, (String)"Cannot write the part since it's not writable now, state: %s", (Object[])new Object[]{this.state});
        this.out.write(b, off, len);
    }

    @Override
    public synchronized void complete() throws IOException {
        Preconditions.checkState((this.state == State.WRITABLE ? 1 : 0) != 0, (String)"Cannot complete the part since it's not writable now, state: %s", (Object[])new Object[]{this.state});
        this.out.close();
        this.state = State.READABLE;
    }

    @Override
    public synchronized InputStream newIn() {
        Preconditions.checkState((this.state == State.READABLE ? 1 : 0) != 0, (String)"Cannot read the part since it's not readable now, state: %s.", (Object[])new Object[]{this.state});
        return this.out.newIn();
    }

    @Override
    public synchronized long size() {
        return this.out.size();
    }

    @Override
    public synchronized State state() {
        return this.state;
    }

    @Override
    public synchronized void cleanup() {
        if (this.state != State.CLEANED) {
            try {
                CommonUtils.runQuietly(this.out::close, false);
                Files.deleteIfExists(this.path);
            }
            catch (Exception e) {
                LOG.error("Failed to delete staging file, stagingFile: {}", (Object)this.path, (Object)e);
            }
            finally {
                this.state = State.CLEANED;
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("stagingBufferSize", this.stagingBufferSize).add("wroteByteSize", this.size()).toString();
    }

    private static final class StagingFileOutputStream
    extends OutputStream {
        private final Path path;
        private byte[] buffer;
        private boolean memBuffered;
        private int writePos;
        private OutputStream out;

        private StagingFileOutputStream(Path path, int stagingBufferSize) {
            this.path = path;
            this.buffer = new byte[stagingBufferSize];
            this.memBuffered = true;
            this.writePos = 0;
        }

        private int size() {
            return this.writePos;
        }

        public InputStream newIn() {
            if (this.memBuffered) {
                return new ByteArrayInputStream(this.buffer, 0, this.writePos);
            }
            try {
                return new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.memBuffered && this.writePos + len > this.buffer.length) {
                this.flushMemToFile();
            }
            if (this.memBuffered) {
                System.arraycopy(b, off, this.buffer, this.writePos, len);
            } else {
                this.out.write(b, off, len);
            }
            this.writePos += len;
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }

        private void flushMemToFile() throws IOException {
            this.out = new BufferedOutputStream(Files.newOutputStream(this.path, new OpenOption[0]));
            this.out.write(this.buffer, 0, this.writePos);
            this.memBuffered = false;
            this.buffer = null;
        }
    }
}

