/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object.request;

public final class ListObjectsRequest {
    private final String prefix;
    private final String startAfter;
    private final int maxKeys;
    private final String delimiter;

    private ListObjectsRequest(String prefix, String startAfter, int maxKeys, String delimiter) {
        this.prefix = prefix;
        this.startAfter = startAfter;
        this.maxKeys = maxKeys;
        this.delimiter = delimiter;
    }

    public String prefix() {
        return this.prefix;
    }

    public String startAfter() {
        return this.startAfter;
    }

    public int maxKeys() {
        return this.maxKeys;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String prefix;
        private String startAfter;
        private int maxKeys = -1;
        private String delimiter;

        public Builder prefix(String prefixInput) {
            this.prefix = prefixInput;
            return this;
        }

        public Builder startAfter(String startAfterInput) {
            this.startAfter = startAfterInput;
            return this;
        }

        public Builder maxKeys(int maxKeysInput) {
            this.maxKeys = maxKeysInput;
            return this;
        }

        public Builder delimiter(String delimiterInput) {
            this.delimiter = delimiterInput;
            return this;
        }

        public ListObjectsRequest build() {
            return new ListObjectsRequest(this.prefix, this.startAfter, this.maxKeys, this.delimiter);
        }
    }
}

