/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.object.BucketInfo;
import org.apache.hadoop.fs.tosfs.object.ChecksumInfo;
import org.apache.hadoop.fs.tosfs.object.DirectoryStorage;
import org.apache.hadoop.fs.tosfs.object.InputStreamProvider;
import org.apache.hadoop.fs.tosfs.object.MultipartUpload;
import org.apache.hadoop.fs.tosfs.object.ObjectContent;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.object.Part;
import org.apache.hadoop.fs.tosfs.object.request.ListObjectsRequest;
import org.apache.hadoop.fs.tosfs.object.response.ListObjectsResponse;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.util.Preconditions;

public class PrefixStorage
implements DirectoryStorage {
    private final ObjectStorage storage;
    private final String prefix;

    public PrefixStorage(ObjectStorage storage, String prefix) {
        this.storage = storage;
        this.prefix = prefix;
    }

    @Override
    public String scheme() {
        return this.storage.scheme();
    }

    @Override
    public BucketInfo bucket() {
        return this.storage.bucket();
    }

    @Override
    public void initialize(Configuration conf, String bucket) {
        this.storage.initialize(conf, bucket);
    }

    @Override
    public Configuration conf() {
        return this.storage.conf();
    }

    @Override
    public ObjectContent get(String key, long offset, long limit) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.storage.get(this.prefix + key, offset, limit);
    }

    @Override
    public byte[] put(String key, InputStreamProvider streamProvider, long contentLength) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.storage.put(this.prefix + key, streamProvider, contentLength);
    }

    @Override
    public byte[] append(String key, InputStreamProvider streamProvider, long contentLength) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.storage.append(this.prefix + key, streamProvider, contentLength);
    }

    @Override
    public void delete(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        this.storage.delete(this.prefix + key);
    }

    @Override
    public List<String> batchDelete(List<String> keys) {
        return this.storage.batchDelete(keys.stream().map(key -> this.prefix + key).collect(Collectors.toList()));
    }

    @Override
    public void deleteAll(String prefixToDelete) {
        this.storage.deleteAll(this.prefix + prefixToDelete);
    }

    @Override
    public ObjectInfo head(String key) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.removePrefix(this.storage.head(this.prefix + key));
    }

    private ListObjectsResponse removePrefix(ListObjectsResponse response) {
        List<ObjectInfo> objects = response.objects().stream().map(this::removePrefix).collect(Collectors.toList());
        List<String> commonPrefixKeys = response.commonPrefixes().stream().map(this::removePrefix).collect(Collectors.toList());
        return new ListObjectsResponse(objects, commonPrefixKeys);
    }

    @Override
    public Iterable<ListObjectsResponse> list(ListObjectsRequest request) {
        String startAfter = Strings.isNullOrEmpty((String)request.startAfter()) ? request.startAfter() : this.prefix + request.startAfter();
        ListObjectsRequest newReq = ListObjectsRequest.builder().prefix(this.prefix + request.prefix()).startAfter(startAfter).maxKeys(request.maxKeys()).delimiter(request.delimiter()).build();
        return Iterables.transform(this.storage.list(newReq), this::removePrefix);
    }

    @Override
    public MultipartUpload createMultipartUpload(String key) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.removePrefix(this.storage.createMultipartUpload(this.prefix + key));
    }

    @Override
    public Part uploadPart(String key, String uploadId, int partNum, InputStreamProvider streamProvider, long contentLength) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.storage.uploadPart(this.prefix + key, uploadId, partNum, streamProvider, contentLength);
    }

    @Override
    public byte[] completeUpload(String key, String uploadId, List<Part> uploadParts) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.storage.completeUpload(this.prefix + key, uploadId, uploadParts);
    }

    @Override
    public void abortMultipartUpload(String key, String uploadId) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        this.storage.abortMultipartUpload(this.prefix + key, uploadId);
    }

    @Override
    public Iterable<MultipartUpload> listUploads(String keyPrefix) {
        return Iterables.transform(this.storage.listUploads(this.prefix + keyPrefix), this::removePrefix);
    }

    @Override
    public Part uploadPartCopy(String srcKey, String dstKey, String uploadId, int partNum, long copySourceRangeStart, long copySourceRangeEnd) {
        return this.storage.uploadPartCopy(this.prefix + srcKey, this.prefix + dstKey, uploadId, partNum, copySourceRangeStart, copySourceRangeEnd);
    }

    @Override
    public void copy(String srcKey, String dstKey) {
        this.storage.copy(this.prefix + srcKey, this.prefix + dstKey);
    }

    @Override
    public void rename(String srcKey, String dstKey) {
        this.storage.rename(this.prefix + srcKey, this.prefix + dstKey);
    }

    private ObjectInfo removePrefix(ObjectInfo o) {
        if (o == null) {
            return null;
        }
        return new ObjectInfo(this.removePrefix(o.key()), o.size(), o.mtime(), o.checksum(), o.isDir());
    }

    private MultipartUpload removePrefix(MultipartUpload u) {
        if (u == null) {
            return null;
        }
        return new MultipartUpload(this.removePrefix(u.key()), u.uploadId(), u.minPartSize(), u.maxPartCount());
    }

    private String removePrefix(String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith(this.prefix)) {
            return key.substring(this.prefix.length());
        }
        return key;
    }

    @Override
    public void putTags(String key, Map<String, String> newTags) {
        this.storage.putTags(this.prefix + key, newTags);
    }

    @Override
    public Map<String, String> getTags(String key) {
        return this.storage.getTags(this.prefix + key);
    }

    @Override
    public ObjectInfo objectStatus(String key) {
        Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"Object key cannot be null or empty.");
        return this.removePrefix(this.storage.objectStatus(this.prefix + key));
    }

    @Override
    public ChecksumInfo checksumInfo() {
        return this.storage.checksumInfo();
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    @Override
    public Iterable<ObjectInfo> listDir(String key, boolean recursive) {
        Preconditions.checkArgument((boolean)(this.storage instanceof DirectoryStorage));
        return Iterables.transform(((DirectoryStorage)this.storage).listDir(this.prefix + key, recursive), this::removePrefix);
    }

    @Override
    public void deleteDir(String key, boolean recursive) {
        Preconditions.checkArgument((boolean)(this.storage instanceof DirectoryStorage));
        ((DirectoryStorage)this.storage).deleteDir(this.prefix + key, recursive);
    }

    @Override
    public boolean isEmptyDir(String key) {
        Preconditions.checkArgument((boolean)(this.storage instanceof DirectoryStorage));
        return ((DirectoryStorage)this.storage).isEmptyDir(this.prefix + key);
    }
}

