/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.util.Range;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;

public final class ObjectUtils {
    public static final String SLASH = "/";

    private ObjectUtils() {
    }

    public static Path keyToPath(String key) {
        return new Path(SLASH + key);
    }

    public static String path(String key) {
        return key.startsWith(SLASH) ? key : SLASH + key;
    }

    public static String pathToKey(Path p) {
        return ObjectUtils.pathToKey(p, false);
    }

    public static String pathToKey(Path p, Boolean isDir) {
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)"Null path");
        if (p.toUri().getScheme() != null && p.toUri().getPath().isEmpty()) {
            return "";
        }
        String key = p.toUri().getPath().substring(1);
        if (isDir.booleanValue() && !key.isEmpty()) {
            return key.endsWith(SLASH) ? key : key + SLASH;
        }
        return key;
    }

    public static void deleteAllObjects(ObjectStorage storage, Iterable<ObjectInfo> objects, int batchSize) {
        ArrayList keysToDelete = Lists.newArrayList();
        for (ObjectInfo obj : objects) {
            keysToDelete.add(obj.key());
            if (keysToDelete.size() != batchSize) continue;
            ObjectUtils.batchDelete(storage, keysToDelete);
            keysToDelete.clear();
        }
        if (!keysToDelete.isEmpty()) {
            ObjectUtils.batchDelete(storage, keysToDelete);
        }
    }

    private static void batchDelete(ObjectStorage storage, List<String> keys) {
        List<String> failedKeys = storage.batchDelete(keys);
        if (!failedKeys.isEmpty()) {
            throw new RuntimeException(String.format("Failed to delete %s objects, detail: %s", failedKeys.size(), Joiner.on((String)",").join(failedKeys)));
        }
    }

    public static Range calculateRange(long offset, long limit, long objSize) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)String.format("offset is a negative number: %s", offset));
        Preconditions.checkArgument((offset <= objSize ? 1 : 0) != 0, (Object)String.format("offset: %s is bigger than object size: %s", offset, objSize));
        long len = limit < 0L ? objSize - offset : Math.min(objSize - offset, limit);
        return Range.of(offset, len);
    }
}

