/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.conf.ConfKeys;
import org.apache.hadoop.fs.tosfs.object.FileStore;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.object.PrefixStorage;
import org.apache.hadoop.fs.tosfs.object.tos.TOS;
import org.apache.hadoop.util.Preconditions;

public final class ObjectStorageFactory {
    private static final Configuration DEFAULT_IMPLS = new Configuration();

    private ObjectStorageFactory() {
    }

    public static ObjectStorage createWithPrefix(String prefix, String scheme, String bucket, Configuration conf) {
        ObjectStorage storage = ObjectStorageFactory.create(scheme, bucket, conf);
        return new PrefixStorage(storage, prefix);
    }

    public static ObjectStorage create(String scheme, String bucket, Configuration conf) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)scheme), (Object)"Scheme is null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)bucket), (Object)"Bucket is null or empty.");
        Preconditions.checkNotNull((Object)conf, (Object)"Conf is null.");
        try {
            String confKey = ConfKeys.FS_OBJECT_STORAGE_IMPL.key(scheme);
            String impl = conf.get(confKey, DEFAULT_IMPLS.get(confKey));
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)impl), (String)"Cannot locate the ObjectStorage implementation for scheme '%s'", (Object[])new Object[]{scheme});
            ObjectStorage store = (ObjectStorage)Class.forName(impl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            store.initialize(conf, bucket);
            return store;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DEFAULT_IMPLS.set(ConfKeys.FS_OBJECT_STORAGE_IMPL.key("tos"), TOS.class.getName());
        DEFAULT_IMPLS.set(ConfKeys.FS_OBJECT_STORAGE_IMPL.key("filestore"), FileStore.class.getName());
    }
}

