/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.object.BucketInfo;
import org.apache.hadoop.fs.tosfs.object.ChecksumInfo;
import org.apache.hadoop.fs.tosfs.object.InputStreamProvider;
import org.apache.hadoop.fs.tosfs.object.MultipartUpload;
import org.apache.hadoop.fs.tosfs.object.ObjectContent;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.fs.tosfs.object.Part;
import org.apache.hadoop.fs.tosfs.object.request.ListObjectsRequest;
import org.apache.hadoop.fs.tosfs.object.response.ListObjectsResponse;
import org.apache.hadoop.fs.tosfs.util.LazyReload;

public interface ObjectStorage
extends Closeable {
    public static final String EMPTY_DELIMITER = "";

    public String scheme();

    public BucketInfo bucket();

    public void initialize(Configuration var1, String var2);

    public Configuration conf();

    default public ObjectContent get(String key) {
        return this.get(key, 0L, -1L);
    }

    public ObjectContent get(String var1, long var2, long var4);

    default public byte[] put(String key, byte[] data) {
        return this.put(key, data, 0, data.length);
    }

    default public byte[] put(String key, byte[] data, int off, int len) {
        return this.put(key, () -> new ByteArrayInputStream(data, off, len), len);
    }

    public byte[] put(String var1, InputStreamProvider var2, long var3);

    default public byte[] append(String key, byte[] data) {
        return this.append(key, data, 0, data.length);
    }

    default public byte[] append(String key, byte[] data, int off, int len) {
        return this.append(key, () -> new ByteArrayInputStream(data, off, len), len);
    }

    public byte[] append(String var1, InputStreamProvider var2, long var3);

    public void delete(String var1);

    public List<String> batchDelete(List<String> var1);

    public void deleteAll(String var1);

    public ObjectInfo head(String var1);

    public Iterable<ListObjectsResponse> list(ListObjectsRequest var1);

    default public Iterable<ObjectInfo> list(String prefix, String startAfter, int limit) {
        ListObjectsRequest request = ListObjectsRequest.builder().prefix(prefix).startAfter(startAfter).maxKeys(limit).delimiter(EMPTY_DELIMITER).build();
        return new LazyReload<ObjectInfo>(() -> {
            Iterator<ListObjectsResponse> iterator = this.list(request).iterator();
            return buf -> {
                if (!iterator.hasNext()) {
                    return true;
                }
                buf.addAll(((ListObjectsResponse)iterator.next()).objects());
                return !iterator.hasNext();
            };
        });
    }

    default public Iterable<ObjectInfo> listAll(String prefix, String startAfter) {
        return this.list(prefix, startAfter, -1);
    }

    public MultipartUpload createMultipartUpload(String var1);

    public Part uploadPart(String var1, String var2, int var3, InputStreamProvider var4, long var5);

    public byte[] completeUpload(String var1, String var2, List<Part> var3);

    public void abortMultipartUpload(String var1, String var2);

    public Iterable<MultipartUpload> listUploads(String var1);

    public Part uploadPartCopy(String var1, String var2, String var3, int var4, long var5, long var7);

    public void copy(String var1, String var2);

    public void rename(String var1, String var2);

    default public void putTags(String key, Map<String, String> newTags) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support putObjectTagging.");
    }

    default public Map<String, String> getTags(String key) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support getObjectTagging.");
    }

    public ObjectInfo objectStatus(String var1);

    public ChecksumInfo checksumInfo();
}

