/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.object.ObjectUtils;
import org.apache.hadoop.fs.tosfs.util.FSUtils;
import org.apache.hadoop.fs.tosfs.util.Range;
import org.apache.hadoop.thirdparty.com.google.common.io.ByteStreams;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Ints;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectRangeInputStream
extends FSInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectRangeInputStream.class);
    private static final int MAX_SKIP_SIZE = 0x100000;
    private final ObjectStorage storage;
    private final String objectKey;
    private final Range range;
    private final byte[] checksum;
    private InputStream stream;
    private long nextPos;
    private long currPos;
    private boolean closed = false;

    public ObjectRangeInputStream(ObjectStorage storage, Path path, Range range, byte[] checksum) {
        this(storage, ObjectUtils.pathToKey(path), range, checksum);
    }

    public ObjectRangeInputStream(ObjectStorage storage, String objectKey, Range range, byte[] checksum) {
        this.storage = storage;
        this.objectKey = objectKey;
        this.range = range;
        this.checksum = checksum;
        this.stream = null;
        this.currPos = this.nextPos = range.off();
        Preconditions.checkNotNull((Object)checksum, (Object)"Checksum should not be null.");
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, buf.length);
        if (n < 0) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        FSUtils.checkReadParameters(buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        if (!this.range.include(this.nextPos)) {
            return -1;
        }
        this.seekStream();
        int toRead = Math.min(length, Ints.saturatedCast((long)(this.range.end() - this.nextPos)));
        int readLen = this.stream.read(buffer, offset, toRead);
        if (readLen > 0) {
            this.nextPos += (long)readLen;
            this.currPos += (long)readLen;
        }
        return readLen;
    }

    public void close() throws IOException {
        super.close();
        this.closeStream();
        this.closed = true;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        FSUtils.checkReadParameters(buffer, offset, length);
        if (!this.range.include(position)) {
            return -1;
        }
        int toRead = Math.min(length, Ints.saturatedCast((long)(this.range.end() - position)));
        if (toRead == 0) {
            return 0;
        }
        try (InputStream in = this.openStream(position, toRead);){
            int n = in.read(buffer, offset, toRead);
            return n;
        }
    }

    public void seek(long pos) throws IOException {
        this.checkNotClosed();
        Preconditions.checkArgument((boolean)this.range.include(pos), (String)"Position %s must be in range %s", (Object[])new Object[]{pos, this.range});
        this.nextPos = pos;
    }

    public long getPos() throws IOException {
        this.checkNotClosed();
        return this.nextPos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        this.checkNotClosed();
        return false;
    }

    private void seekStream() throws IOException {
        long skip;
        if (this.stream != null && this.nextPos == this.currPos) {
            return;
        }
        if (this.stream != null && this.nextPos > this.currPos && (skip = this.nextPos - this.currPos) < 0x100000L) {
            try {
                ByteStreams.skipFully((InputStream)this.stream, (long)skip);
                this.currPos = this.nextPos;
                return;
            }
            catch (IOException ignored) {
                LOG.warn("Failed to skip {} bytes in stream, will try to reopen the stream", (Object)skip);
            }
        }
        this.currPos = this.nextPos;
        this.closeStream();
        this.stream = this.openStream(this.nextPos, this.range.end() - this.nextPos);
    }

    private InputStream openStream(long offset, long limit) throws IOException {
        return this.storage.get(this.objectKey, offset, limit).verifiedStream(this.checksum);
    }

    private void closeStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    public boolean include(long pos) {
        return this.range.include(pos);
    }

    public Range range() {
        return this.range;
    }
}

