/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.tosfs.object.ObjectRangeInputStream;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.object.ObjectUtils;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;
import org.apache.hadoop.fs.tosfs.util.FSUtils;
import org.apache.hadoop.fs.tosfs.util.Range;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Ints;
import org.apache.hadoop.util.Preconditions;

public class ObjectMultiRangeInputStream
extends FSInputStream {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ExecutorService threadPool;
    private final ObjectStorage storage;
    private final String objectKey;
    private final long contentLength;
    private final long rangeSize;
    private volatile ObjectRangeInputStream stream;
    private volatile long nextPos = 0L;
    private volatile long currPos = 0L;
    private final byte[] checksum;

    public ObjectMultiRangeInputStream(ExecutorService threadPool, ObjectStorage storage, Path path, long contentLength, long rangeSize, byte[] checksum) {
        this(threadPool, storage, ObjectUtils.pathToKey(path), contentLength, rangeSize, checksum);
    }

    public ObjectMultiRangeInputStream(ExecutorService threadPool, ObjectStorage storage, String objectKey, long contentLength, long rangeSize, byte[] checksum) {
        this.threadPool = threadPool;
        this.storage = storage;
        this.objectKey = objectKey;
        this.contentLength = contentLength;
        this.rangeSize = rangeSize;
        this.checksum = checksum;
        Preconditions.checkNotNull((Object)checksum, (Object)"Checksum should not be null.");
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + pos);
        }
        if (this.contentLength <= 0L) {
            return;
        }
        this.nextPos = pos;
    }

    public synchronized long getPos() {
        return this.nextPos;
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        this.checkNotClosed();
        return false;
    }

    public synchronized int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, buf.length);
        if (n < 0) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        FSUtils.checkReadParameters(buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        int total = 0;
        while (total < length) {
            if (this.contentLength == 0L || this.nextPos >= this.contentLength) {
                return total == 0 ? -1 : total;
            }
            this.seekStream();
            int n = this.stream.read(buffer, offset, length - total);
            if (n < 0) {
                return total == 0 ? -1 : total;
            }
            total += n;
            offset += n;
            this.currPos += (long)n;
            this.nextPos += (long)n;
        }
        return total;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        if (position < 0L) {
            throw new EOFException("position is negative");
        }
        FSUtils.checkReadParameters(buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        if (this.contentLength == 0L || position >= this.contentLength) {
            return -1;
        }
        long remaining = this.contentLength - position;
        int limit = remaining >= (long)length ? length : (int)remaining;
        try (InputStream in = this.storage.get(this.objectKey, position, limit).verifiedStream(this.checksum);){
            int n = in.read(buffer, offset, limit);
            return n;
        }
    }

    private void seekStream() throws IOException {
        if (this.stream != null && this.stream.include(this.nextPos)) {
            if (this.nextPos != this.currPos) {
                this.stream.seek(this.nextPos);
                this.currPos = this.nextPos;
            }
            return;
        }
        this.currPos = this.nextPos;
        this.openStream();
    }

    private void openStream() throws IOException {
        this.closeStream(true);
        long off = this.nextPos / this.rangeSize * this.rangeSize;
        Range range = Range.of(off, Math.min(this.contentLength - off, this.rangeSize));
        if (this.nextPos < range.end()) {
            this.stream = new ObjectRangeInputStream(this.storage, this.objectKey, range, this.checksum);
            this.stream.seek(this.nextPos);
        }
    }

    private void closeStream(boolean asyncClose) throws IOException {
        if (this.stream != null) {
            if (asyncClose) {
                ObjectRangeInputStream streamToClose = this.stream;
                this.threadPool.submit(() -> CommonUtils.runQuietly(streamToClose::close));
            } else {
                this.stream.close();
            }
            this.stream = null;
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream is closed!");
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.closed.compareAndSet(false, true)) {
            this.closeStream(false);
        }
    }

    public long nextExpectPos() {
        return this.currPos;
    }

    public synchronized int available() throws IOException {
        this.checkNotClosed();
        return Ints.saturatedCast((long)(this.contentLength - this.nextPos));
    }

    @VisibleForTesting
    ObjectRangeInputStream stream() {
        return this.stream;
    }
}

