/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.hadoop.fs.tosfs.object.Constants;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;

public class ObjectInfo {
    private final String key;
    private final long size;
    private final Date mtime;
    private final boolean isDir;
    private final byte[] checksum;

    public ObjectInfo(String key, long size, Date mtime, byte[] checksum) {
        this(key, size, mtime, checksum, ObjectInfo.isDir(key));
    }

    public ObjectInfo(String key, long size, Date mtime, byte[] checksum, boolean isDir) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key is null");
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"The size of key(%s) is negative", (Object[])new Object[]{key});
        Preconditions.checkArgument((mtime != null ? 1 : 0) != 0, (String)"The modified time of key(%s) null.", (Object[])new Object[]{key});
        this.key = key;
        this.size = size;
        this.mtime = mtime;
        this.isDir = isDir;
        this.checksum = checksum == null || isDir ? Constants.MAGIC_CHECKSUM : checksum;
    }

    public String key() {
        return this.key;
    }

    public long size() {
        return this.isDir ? 0L : this.size;
    }

    public Date mtime() {
        return this.mtime;
    }

    public byte[] checksum() {
        return this.checksum;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectInfo)) {
            return false;
        }
        ObjectInfo that = (ObjectInfo)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.size, that.size) && Objects.equals(this.mtime, that.mtime) && Arrays.equals(this.checksum, that.checksum) && Objects.equals(this.isDir, that.isDir);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.size, this.mtime, Arrays.hashCode(this.checksum), this.isDir);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("size", this.size).add("mtime", (Object)this.mtime).add("checksum", (Object)StringUtils.byteToHexString((byte[])this.checksum)).add("isDir", this.isDir).toString();
    }

    public static boolean isDir(String key) {
        return key.endsWith("/");
    }
}

