/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.tosfs.object.exceptions.ChecksumMismatchException;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;

public class ObjectContent {
    private final byte[] checksum;
    private final InputStream stream;

    public ObjectContent(byte[] checksum, InputStream stream) {
        this.checksum = checksum;
        this.stream = stream;
    }

    public InputStream stream() {
        return this.stream;
    }

    public InputStream verifiedStream(byte[] expectedChecksum) throws ChecksumMismatchException {
        if (!Arrays.equals(expectedChecksum, this.checksum)) {
            CommonUtils.runQuietly(this.stream::close);
            throw new ChecksumMismatchException(expectedChecksum, this.checksum);
        }
        return this.stream;
    }

    public byte[] checksum() {
        return this.checksum;
    }
}

