/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.util.Objects;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;

public class MultipartUpload
implements Comparable<MultipartUpload> {
    private final String key;
    private final String uploadId;
    private final int minPartSize;
    private final int maxPartCount;

    public MultipartUpload(String key, String uploadId, int minPartSize, int maxPartCount) {
        this.key = key;
        this.uploadId = uploadId;
        this.minPartSize = minPartSize;
        this.maxPartCount = maxPartCount;
    }

    public String key() {
        return this.key;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public int minPartSize() {
        return this.minPartSize;
    }

    public int maxPartCount() {
        return this.maxPartCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipartUpload)) {
            return false;
        }
        MultipartUpload that = (MultipartUpload)o;
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.uploadId, that.uploadId)) {
            return false;
        }
        if (!Objects.equals(this.minPartSize, that.minPartSize)) {
            return false;
        }
        return Objects.equals(this.maxPartCount, that.maxPartCount);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.uploadId, this.minPartSize, this.maxPartCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("uploadId", (Object)this.uploadId).add("minPartSize", this.minPartSize).add("maxPartCount", this.maxPartCount).toString();
    }

    @Override
    public int compareTo(MultipartUpload o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        if (this.key.compareTo(o.key) == 0) {
            return this.uploadId.compareTo(o.uploadId);
        }
        return this.key.compareTo(o.key);
    }
}

