/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.object;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.tosfs.conf.ConfKeys;
import org.apache.hadoop.fs.tosfs.conf.FileStoreKeys;
import org.apache.hadoop.fs.tosfs.object.BucketInfo;
import org.apache.hadoop.fs.tosfs.object.ChecksumInfo;
import org.apache.hadoop.fs.tosfs.object.ChecksumType;
import org.apache.hadoop.fs.tosfs.object.Constants;
import org.apache.hadoop.fs.tosfs.object.InputStreamProvider;
import org.apache.hadoop.fs.tosfs.object.MultipartUpload;
import org.apache.hadoop.fs.tosfs.object.ObjectContent;
import org.apache.hadoop.fs.tosfs.object.ObjectInfo;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.object.ObjectUtils;
import org.apache.hadoop.fs.tosfs.object.Part;
import org.apache.hadoop.fs.tosfs.object.exceptions.NotAppendableException;
import org.apache.hadoop.fs.tosfs.object.request.ListObjectsRequest;
import org.apache.hadoop.fs.tosfs.object.response.ListObjectsResponse;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;
import org.apache.hadoop.fs.tosfs.util.Range;
import org.apache.hadoop.fs.tosfs.util.UUIDUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStore
implements ObjectStorage {
    private static final Logger LOG = LoggerFactory.getLogger(FileStore.class);
    private static final String NAME = "filestore";
    private static final String STAGING_DIR = "__STAGING__";
    private static final String SLASH = "/";
    public static final String DEFAULT_BUCKET = "dummy-bucket";
    public static final String ENV_FILE_STORAGE_ROOT = "FILE_STORAGE_ROOT";
    private static final int MAX_DELETE_OBJECTS_COUNT = 1000;
    private static final int MIN_PART_SIZE = 0x500000;
    private static final int MAX_PART_COUNT = 10000;
    private String bucket;
    private String root;
    private Configuration conf;
    private ChecksumInfo checksumInfo;

    @Override
    public String scheme() {
        return NAME;
    }

    @Override
    public BucketInfo bucket() {
        return new BucketInfo(this.bucket, false);
    }

    @Override
    public void initialize(Configuration config, String bucketName) {
        this.bucket = bucketName;
        this.conf = config;
        String endpoint = config.get(ConfKeys.FS_OBJECT_STORAGE_ENDPOINT.key(NAME));
        if (endpoint == null || endpoint.isEmpty()) {
            endpoint = System.getenv(ENV_FILE_STORAGE_ROOT);
        }
        Preconditions.checkNotNull((Object)endpoint, (String)"%s cannot be null", (Object[])new Object[]{ConfKeys.FS_OBJECT_STORAGE_ENDPOINT.key(NAME)});
        this.root = endpoint.endsWith(SLASH) ? endpoint : endpoint + SLASH;
        LOG.debug("the root path is: {}", (Object)this.root);
        String algorithm = config.get("fs.filestore.checksum-algorithm", "TOS-CHECKSUM");
        ChecksumType checksumType = ChecksumType.valueOf(config.get("fs.filestore.checksum-type", FileStoreKeys.FS_FILESTORE_CHECKSUM_TYPE_DEFAULT).toUpperCase());
        Preconditions.checkArgument((checksumType == ChecksumType.MD5 ? 1 : 0) != 0, (String)"Checksum type %s is not supported by FileStore.", (Object[])new Object[]{checksumType.name()});
        this.checksumInfo = new ChecksumInfo(algorithm, checksumType);
        File rootDir = new File(this.root);
        if (!rootDir.mkdirs() && !rootDir.exists()) {
            throw new IllegalArgumentException("Failed to create root dir. " + this.root);
        }
        LOG.info("Create root dir successfully. {}", (Object)this.root);
    }

    @Override
    public Configuration conf() {
        return this.conf;
    }

    private static String encode(String key) {
        try {
            return URLEncoder.encode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("failed to encode key: {}", (Object)key);
            return key;
        }
    }

    private static String decode(String key) {
        try {
            return URLDecoder.decode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("failed to decode key: {}", (Object)key);
            return key;
        }
    }

    @Override
    public ObjectContent get(String key, long offset, long limit) {
        ObjectContent objectContent;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        File file = this.path(FileStore.encode(key)).toFile();
        if (!file.exists()) {
            throw new RuntimeException(String.format("File not found %s", file.getAbsolutePath()));
        }
        Range range = ObjectUtils.calculateRange(offset, limit, file.length());
        FileInputStream in = new FileInputStream(file);
        try {
            in.skip(range.off());
            byte[] bs = new byte[(int)range.len()];
            in.read(bs);
            byte[] fileChecksum = this.getFileChecksum(file.toPath());
            objectContent = new ObjectContent(fileChecksum, new ByteArrayInputStream(bs));
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return objectContent;
    }

    @Override
    public byte[] put(String key, InputStreamProvider streamProvider, long contentLength) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        File destFile = this.path(FileStore.encode(key)).toFile();
        FileStore.copyInputStreamToFile(streamProvider.newStream(), destFile, contentLength);
        return ObjectInfo.isDir(key) ? Constants.MAGIC_CHECKSUM : this.getFileChecksum(destFile.toPath());
    }

    @Override
    public byte[] append(String key, InputStreamProvider streamProvider, long contentLength) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        File destFile = this.path(FileStore.encode(key)).toFile();
        if (!destFile.exists()) {
            if (contentLength == 0L) {
                throw new NotAppendableException(String.format("%s is not appendable because append non-existed object with zero byte is not supported.", key));
            }
            return this.put(key, streamProvider, contentLength);
        }
        FileStore.appendInputStreamToFile(streamProvider.newStream(), destFile, contentLength);
        return ObjectInfo.isDir(key) ? Constants.MAGIC_CHECKSUM : this.getFileChecksum(destFile.toPath());
    }

    private static File createTmpFile(File destFile) {
        String tmpFilename = ".tmp." + UUIDUtils.random();
        File file = new File(destFile.getParentFile(), tmpFilename);
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new RuntimeException("failed to create tmp file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    @Override
    public void delete(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        File file = this.path(FileStore.encode(key)).toFile();
        if (file.exists()) {
            try {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory((File)file);
                } else {
                    Files.delete(file.toPath());
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public List<String> batchDelete(List<String> keys) {
        Preconditions.checkArgument((keys.size() <= 1000 ? 1 : 0) != 0, (String)"The batch delete object count should <= %s", (Object[])new Object[]{1000});
        ArrayList failedKeys = Lists.newArrayList();
        for (String key : keys) {
            try {
                this.delete(key);
            }
            catch (Exception e) {
                LOG.error("Failed to delete key {}", (Object)key, (Object)e);
                failedKeys.add(key);
            }
        }
        return failedKeys;
    }

    @Override
    public void deleteAll(String prefix) {
        Iterable<ObjectInfo> objects = this.listAll(prefix, "");
        ObjectUtils.deleteAllObjects(this, objects, this.conf.getInt(ConfKeys.FS_BATCH_DELETE_SIZE.key(NAME), 250));
    }

    @Override
    public ObjectInfo head(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        File file = this.path(FileStore.encode(key)).toFile();
        if (file.exists()) {
            return this.toObjectInfo(file.toPath());
        }
        return null;
    }

    @Override
    public Iterable<ListObjectsResponse> list(ListObjectsRequest request) {
        List<ListObjectsResponse> list;
        block8: {
            Stream<Path> stream = Files.walk(Paths.get(this.root, new String[0]), new FileVisitOption[0]);
            try {
                List<ObjectInfo> allObjects = this.list(stream, request.prefix(), request.startAfter()).collect(Collectors.toList());
                int maxKeys = request.maxKeys() < 0 ? allObjects.size() : request.maxKeys();
                list = Collections.singletonList(this.splitObjects(request.prefix(), request.delimiter(), maxKeys, request.startAfter(), allObjects));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    private ListObjectsResponse splitObjects(String prefix, String delimiter, int limit, String startAfter, List<ObjectInfo> objects) {
        int retSize = Math.min(limit, objects.size());
        if (Strings.isNullOrEmpty((String)delimiter)) {
            List<ObjectInfo> retObjs = objects.subList(0, retSize);
            return new ListObjectsResponse(retObjs, Collections.emptyList());
        }
        TreeSet<CallSite> commonPrefixes = new TreeSet<CallSite>();
        ArrayList<ObjectInfo> objectInfos = new ArrayList<ObjectInfo>();
        for (ObjectInfo obj : objects) {
            String suffixKey = obj.key().substring(prefix.length());
            String[] tokens = suffixKey.split(delimiter, 2);
            if (tokens.length == 2) {
                String key = prefix + tokens[0] + delimiter;
                if (key.equals(startAfter)) continue;
                commonPrefixes.add((CallSite)((Object)key));
                if (commonPrefixes.size() + objectInfos.size() <= retSize) continue;
                commonPrefixes.remove(key);
                break;
            }
            if (commonPrefixes.size() + objectInfos.size() >= retSize) break;
            objectInfos.add(obj);
        }
        return new ListObjectsResponse(objectInfos, new ArrayList<String>(commonPrefixes));
    }

    @Override
    public MultipartUpload createMultipartUpload(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        String uploadId = UUIDUtils.random();
        Path uploadDir = this.uploadPath(key, uploadId);
        if (uploadDir.toFile().mkdirs()) {
            return new MultipartUpload(key, uploadId, 0x500000, 10000);
        }
        throw new RuntimeException("Failed to create MultipartUpload with key: " + key);
    }

    private Path uploadPath(String key, String uploadId) {
        return Paths.get(this.root, STAGING_DIR, FileStore.encode(key), uploadId);
    }

    @Override
    public Part uploadPart(String key, String uploadId, int partNum, InputStreamProvider streamProvider, long contentLength) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        File uploadDir = this.uploadPath(key, uploadId).toFile();
        if (!uploadDir.exists()) {
            throw new RuntimeException("cannot locate the upload id: " + uploadId);
        }
        File partFile = new File(uploadDir, String.valueOf(partNum));
        FileStore.copyInputStreamToFile(streamProvider.newStream(), partFile, contentLength);
        try {
            byte[] data = Files.readAllBytes(partFile.toPath());
            return new Part(partNum, data.length, DigestUtils.md5Hex((byte[])data));
        }
        catch (IOException e) {
            LOG.error("failed to locate the part file: {}", (Object)partFile.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    private static void appendInputStreamToFile(InputStream in, File partFile, long contentLength) {
        try (FileOutputStream out = new FileOutputStream(partFile, true);){
            long copiedBytes = IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)0L, (long)contentLength);
            if (copiedBytes < contentLength) {
                throw new IOException(String.format("Unexpect end of stream, expected to write length:%s, actual written:%s", contentLength, copiedBytes));
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtils.runQuietly(in::close);
                throw throwable;
            }
        }
        CommonUtils.runQuietly(in::close);
    }

    private static void copyInputStreamToFile(InputStream in, File partFile, long contentLength) {
        File tmpFile = FileStore.createTmpFile(partFile);
        try (FileOutputStream out = new FileOutputStream(tmpFile);){
            long copiedBytes = IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)0L, (long)contentLength);
            if (copiedBytes < contentLength) {
                throw new IOException(String.format("Unexpect end of stream, expected length:%s, actual:%s", contentLength, tmpFile.length()));
            }
        }
        catch (IOException e) {
            try {
                CommonUtils.runQuietly(() -> FileUtils.delete((File)tmpFile));
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtils.runQuietly(in::close);
                throw throwable;
            }
        }
        CommonUtils.runQuietly(in::close);
        if (!tmpFile.renameTo(partFile)) {
            throw new RuntimeException("failed to put file since rename fail.");
        }
    }

    @Override
    public byte[] completeUpload(String key, String uploadId, List<Part> uploadParts) {
        Preconditions.checkArgument((uploadParts != null && uploadParts.size() > 0 ? 1 : 0) != 0, (Object)"upload parts cannot be null or empty.");
        File uploadDir = this.uploadPath(key, uploadId).toFile();
        if (!uploadDir.exists()) {
            throw new RuntimeException("cannot locate the upload id: " + uploadId);
        }
        List<Integer> partNums = this.listPartNums(uploadDir);
        if (partNums.size() != uploadParts.size()) {
            throw new RuntimeException(String.format("parts length mismatched: %d != %d", partNums.size(), uploadParts.size()));
        }
        Collections.sort(partNums);
        uploadParts.sort(Comparator.comparingInt(Part::num));
        Path keyPath = this.path(FileStore.encode(key));
        File tmpFile = FileStore.createTmpFile(keyPath.toFile());
        try (FileOutputStream outputStream = new FileOutputStream(tmpFile);
             FileChannel outputChannel = outputStream.getChannel();){
            int offset = 0;
            for (int i = 0; i < partNums.size(); ++i) {
                Part part = uploadParts.get(i);
                if (part.num() != partNums.get(i).intValue()) {
                    throw new RuntimeException(String.format("part num mismatched: %d != %d", part.num(), partNums.get(i)));
                }
                File partFile = new File(uploadDir, String.valueOf(part.num()));
                FileStore.checkPartFile(part, partFile);
                try (FileInputStream inputStream = new FileInputStream(partFile);
                     FileChannel inputChannel = inputStream.getChannel();){
                    outputChannel.transferFrom(inputChannel, offset, partFile.length());
                    offset = (int)((long)offset + partFile.length());
                    continue;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!tmpFile.renameTo(keyPath.toFile())) {
            throw new RuntimeException("rename file failed");
        }
        try {
            FileUtils.deleteDirectory((File)uploadDir);
        }
        catch (IOException e) {
            LOG.warn("failed to clean upload directory.");
        }
        return this.getFileChecksum(keyPath);
    }

    private byte[] getFileChecksum(Path keyPath) {
        return FileStore.getFileMD5(keyPath);
    }

    private static byte[] getFileMD5(Path keyPath) {
        try {
            return DigestUtils.md5((byte[])Files.readAllBytes(keyPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkPartFile(Part part, File partFile) throws IOException {
        if (part.size() != partFile.length()) {
            throw new RuntimeException(String.format("part size mismatched: %d != %d", part.size(), partFile.length()));
        }
        try (FileInputStream inputStream = new FileInputStream(partFile);){
            String md5Hex = DigestUtils.md5Hex((InputStream)inputStream);
            if (!Objects.equals(part.eTag(), md5Hex)) {
                throw new RuntimeException(String.format("part etag mismatched: %s != %s", part.eTag(), md5Hex));
            }
        }
    }

    private List<Integer> listPartNums(File uploadDir) {
        List<Integer> list;
        block8: {
            Stream<Path> stream = Files.list(uploadDir.toPath());
            try {
                list = stream.map(f -> Integer.valueOf(f.toFile().getName())).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("failed to list part files.");
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    @Override
    public void abortMultipartUpload(String key, String uploadId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Key should not be empty.");
        Path uploadDir = this.uploadPath(key, uploadId);
        if (uploadDir.toFile().exists()) {
            try {
                FileUtils.deleteDirectory((File)uploadDir.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Iterable<MultipartUpload> listUploads(String prefix) {
        Iterable iterable;
        block9: {
            Path stagingDir = Paths.get(this.root, STAGING_DIR);
            if (!Files.exists(stagingDir, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> encodedKeyStream = Files.list(stagingDir);
            try {
                iterable = encodedKeyStream.filter(key -> Objects.equals(prefix, "") || key.toFile().getName().startsWith(FileStore.encode(prefix))).flatMap(key -> {
                    try {
                        return Files.list(key).map(id -> new MultipartUpload(FileStore.decode(key.toFile().getName()), id.toFile().getName(), 0x500000, 10000));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).sorted().collect(Collectors.toList());
                if (encodedKeyStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (encodedKeyStream != null) {
                        try {
                            encodedKeyStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            encodedKeyStream.close();
        }
        return iterable;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Part uploadPartCopy(String srcKey, String dstKey, String uploadId, int partNum, long copySourceRangeStart, long copySourceRangeEnd) {
        File uploadDir = this.uploadPath(dstKey, uploadId).toFile();
        if (!uploadDir.exists()) {
            throw new RuntimeException(String.format("Upload directory %s already exits", uploadDir));
        }
        File partFile = new File(uploadDir, String.valueOf(partNum));
        int fileSize = (int)(copySourceRangeEnd - copySourceRangeStart + 1L);
        try (InputStream is = this.get(srcKey, copySourceRangeStart, fileSize).stream();){
            Part part;
            try (FileOutputStream fos = new FileOutputStream(partFile);){
                byte[] data = new byte[fileSize];
                IOUtils.readFully((InputStream)is, (byte[])data);
                fos.write(data);
                part = new Part(partNum, fileSize, DigestUtils.md5Hex((byte[])data));
            }
            return part;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void copy(String srcKey, String dstKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)srcKey) ? 1 : 0) != 0, (Object)"Src key should not be empty.");
        File file = this.path(FileStore.encode(srcKey)).toFile();
        if (!file.exists()) {
            throw new RuntimeException(String.format("File not found %s", file.getAbsolutePath()));
        }
        this.put(dstKey, () -> this.get(srcKey).stream(), file.length());
    }

    @Override
    public void rename(String srcKey, String dstKey) {
        Preconditions.checkArgument((!Objects.equals(srcKey, dstKey) ? 1 : 0) != 0, (Object)"Cannot rename to the same object");
        Preconditions.checkNotNull((Object)this.head(srcKey), (String)"Source key %s doesn't exist", (Object[])new Object[]{srcKey});
        File srcFile = this.path(FileStore.encode(srcKey)).toFile();
        File dstFile = this.path(FileStore.encode(dstKey)).toFile();
        boolean ret = srcFile.renameTo(dstFile);
        if (!ret) {
            throw new RuntimeException(String.format("Failed to rename %s to %s", srcKey, dstKey));
        }
    }

    @Override
    public ObjectInfo objectStatus(String key) {
        Iterable<ObjectInfo> objs;
        ObjectInfo obj = this.head((String)key);
        if (obj == null && !ObjectInfo.isDir((String)key)) {
            key = (String)key + SLASH;
            obj = this.head((String)key);
        }
        if (obj == null && (objs = this.list((String)key, null, 1)).iterator().hasNext()) {
            obj = new ObjectInfo((String)key, 0L, new Date(0L), Constants.MAGIC_CHECKSUM);
        }
        return obj;
    }

    @Override
    public ChecksumInfo checksumInfo() {
        return this.checksumInfo;
    }

    private Stream<ObjectInfo> list(Stream<Path> stream, String prefix, String startAfter) {
        return stream.filter(p -> {
            String absolutePath = p.toFile().getAbsolutePath();
            return !Objects.equals(this.key(absolutePath), "") && FileStore.decode(this.key(absolutePath)).startsWith(prefix) && !absolutePath.contains(STAGING_DIR) && this.filter(FileStore.decode(this.key(absolutePath)), startAfter);
        }).map(this::toObjectInfo).sorted(Comparator.comparing(ObjectInfo::key));
    }

    private boolean filter(String key, String startAfter) {
        if (Strings.isNullOrEmpty((String)startAfter)) {
            return true;
        }
        return key.compareTo(startAfter) > 0;
    }

    private ObjectInfo toObjectInfo(Path path) {
        File file = path.toFile();
        String key = FileStore.decode(this.key(file.getAbsolutePath()));
        return new ObjectInfo(key, file.length(), new Date(file.lastModified()), this.getFileChecksum(path));
    }

    private Path path(String key) {
        return Paths.get(this.root, key);
    }

    private String key(String path) {
        if (path.length() < this.root.length()) {
            return "";
        }
        return path.substring(this.root.length());
    }

    @Override
    public void close() throws IOException {
    }
}

