/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.conf;

import org.apache.hadoop.fs.tosfs.conf.ArgumentKey;
import org.apache.hadoop.util.Preconditions;

public final class ConfKeys {
    public static final ArgumentKey FS_OBJECT_STORAGE_ENDPOINT = new ArgumentKey("fs.%s.endpoint");
    public static final ArgumentKey FS_OBJECT_STORAGE_REGION = new ArgumentKey("fs.%s.region");
    public static final ArgumentKey FS_OBJECT_STORAGE_IMPL = new ArgumentKey("fs.objectstorage.%s.impl");
    public static final ArgumentKey FS_BATCH_DELETE_SIZE = new ArgumentKey("fs.%s.delete.batch-size");
    public static final int FS_BATCH_DELETE_SIZE_DEFAULT = 250;
    public static final ArgumentKey FS_MULTIPART_SIZE = new ArgumentKey("fs.%s.multipart.size");
    public static final long FS_MULTIPART_SIZE_DEFAULT = 0x800000L;
    public static final ArgumentKey FS_MULTIPART_COPY_THRESHOLD = new ArgumentKey("fs.%s.multipart.copy-threshold");
    public static final long FS_MULTIPART_COPY_THRESHOLD_DEFAULT = 0x500000L;
    public static final ArgumentKey FS_MULTIPART_THRESHOLD = new ArgumentKey("fs.%s.multipart.threshold");
    public static final long FS_MULTIPART_THRESHOLD_DEFAULT = 0xA00000L;
    public static final ArgumentKey FS_MULTIPART_STAGING_BUFFER_SIZE = new ArgumentKey("fs.%s.multipart.staging-buffer-size");
    public static final int FS_MULTIPART_STAGING_BUFFER_SIZE_DEFAULT = 4096;
    public static final ArgumentKey FS_MULTIPART_STAGING_DIR = new ArgumentKey("fs.%s.multipart.staging-dir");
    public static final String FS_MULTIPART_STAGING_DIR_DEFAULT = ConfKeys.defaultDir("multipart-staging-dir");
    public static final ArgumentKey FS_ASYNC_CREATE_MISSED_PARENT = new ArgumentKey("fs.%s.missed.parent.dir.async-create");
    public static final boolean FS_ASYNC_CREATE_MISSED_PARENT_DEFAULT = true;
    public static final ArgumentKey FS_OBJECT_RENAME_ENABLED = new ArgumentKey("fs.%s.rename.enabled");
    public static final boolean FS_OBJECT_RENAME_ENABLED_DEFAULT = false;
    public static final String FS_OBJECT_STREAM_RANGE_SIZE = "fs.objectstorage.stream.range-size";
    public static final long FS_OBJECT_STREAM_RANGE_SIZE_DEFAULT = Long.MAX_VALUE;
    public static final ArgumentKey FS_TASK_THREAD_POOL_SIZE = new ArgumentKey("fs.%s.task.thread-pool-size");
    public static final int FS_TASK_THREAD_POOL_SIZE_DEFAULT = Math.max(2, Runtime.getRuntime().availableProcessors());
    public static final ArgumentKey FS_MULTIPART_THREAD_POOL_SIZE = new ArgumentKey("fs.%s.multipart.thread-pool-size");
    public static final int FS_MULTIPART_THREAD_POOL_SIZE_DEFAULT = Math.max(2, Runtime.getRuntime().availableProcessors());
    public static final ArgumentKey FS_CHECKSUM_ENABLED = new ArgumentKey("fs.%s.checksum.enabled");
    public static final boolean FS_CHECKSUM_ENABLED_DEFAULT = true;

    private ConfKeys() {
    }

    public static String defaultDir(String basename) {
        String tmpdir = System.getProperty("java.io.tmpdir");
        Preconditions.checkNotNull((Object)tmpdir, (Object)"System property 'java.io.tmpdir' cannot be null");
        if (tmpdir.endsWith("/")) {
            return String.format("%s%s", tmpdir, basename);
        }
        return String.format("%s/%s", tmpdir, basename);
    }
}

