/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPools {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPools.class);
    public static final String WORKER_THREAD_POOL_SIZE_PROP = "tos.worker.num-threads";
    public static final int WORKER_THREAD_POOL_SIZE = ThreadPools.poolSize(Math.max(2, Runtime.getRuntime().availableProcessors()));
    private static final ExecutorService WORKER_POOL = ThreadPools.newWorkerPool("tos-default-worker-pool");

    private ThreadPools() {
    }

    public static ExecutorService defaultWorkerPool() {
        return WORKER_POOL;
    }

    public static ExecutorService newWorkerPool(String namePrefix) {
        return ThreadPools.newWorkerPool(namePrefix, WORKER_THREAD_POOL_SIZE);
    }

    public static ExecutorService newWorkerPool(String namePrefix, int poolSize) {
        return Executors.newFixedThreadPool(poolSize, ThreadPools.newDaemonThreadFactory(namePrefix));
    }

    public static ScheduledExecutorService newScheduleWorkerPool(String namePrefix, int poolSize) {
        return Executors.newScheduledThreadPool(poolSize, ThreadPools.newDaemonThreadFactory(namePrefix));
    }

    public static void shutdown(ExecutorService executorService, long timeout, TimeUnit unit) {
        if (executorService == null) {
            return;
        }
        try {
            executorService.shutdown();
            LOG.debug("Gracefully shutting down executor service. Waiting max {} {}", (Object)timeout, (Object)unit);
            if (!executorService.awaitTermination(timeout, unit)) {
                LOG.debug("Executor service has not shutdown yet. Forcing. Will wait up to an additional {} {} for shutdown", (Object)timeout, (Object)unit);
                executorService.shutdownNow();
            }
            if (executorService.awaitTermination(timeout, unit)) {
                LOG.debug("Succesfully shutdown executor service");
            } else {
                LOG.error("Unable to shutdown executor service after timeout {} {}", (Object)(2L * timeout), (Object)unit);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while attempting to shutdown", (Throwable)e);
            executorService.shutdownNow();
        }
        catch (Exception e) {
            LOG.warn("Exception closing executor service {}", (Object)e.getMessage());
            LOG.debug("Exception closing executor service", (Throwable)e);
            throw e;
        }
    }

    private static int poolSize(int defaultSize) {
        String value = System.getProperty(WORKER_THREAD_POOL_SIZE_PROP);
        if (value != null) {
            try {
                return Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultSize;
    }

    public static ThreadFactory newDaemonThreadFactory(String namePrefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(namePrefix + "-%d").setUncaughtExceptionHandler((t, e) -> LOG.error("Thread {} encounter uncaught exception", (Object)t, (Object)e)).build();
    }

    public static Thread newDaemonThread(String name, Runnable runnable, Thread.UncaughtExceptionHandler handler) {
        Thread t = new Thread(runnable);
        t.setName(name);
        t.setDaemon(true);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        return t;
    }
}

