/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.function.Predicate;
import org.apache.hadoop.fs.tosfs.util.CommonUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Queues;
import org.apache.hadoop.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Chain<T extends Closeable>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Chain.class);
    private final List<IOException> suppressed = Lists.newArrayList();
    private final Queue<ItemFactory<T>> queue;
    private final Predicate<IOException> shouldContinue;
    private T curItem;

    private Chain(Deque<ItemFactory<T>> queue, Predicate<IOException> shouldContinue) {
        this.queue = queue;
        this.shouldContinue = shouldContinue;
        this.curItem = null;
    }

    public <R> R run(Task<T, R> task) throws IOException {
        while (true) {
            if (this.curItem == null && !this.nextItem()) {
                IOException ex = new IOException("Failed to run task after attempt all items");
                this.suppressed.forEach(ex::addSuppressed);
                throw ex;
            }
            try {
                return task.run(this.curItem);
            }
            catch (IOException e) {
                LOG.debug("Encounter exception while running task with item {}", this.curItem, (Object)e);
                if (this.curItem != null) {
                    CommonUtils.runQuietly(() -> this.curItem.close());
                    this.curItem = null;
                }
                this.suppressed.add(e);
                if (this.shouldContinue == null || this.shouldContinue.test(e)) continue;
                IOException ex = new IOException("Failed to run the chain since the encountered error not retryable.");
                this.suppressed.forEach(ex::addSuppressed);
                throw ex;
            }
            break;
        }
    }

    public T curItem() {
        return this.curItem;
    }

    private boolean nextItem() {
        if (this.curItem != null) {
            CommonUtils.runQuietly(() -> this.curItem.close());
            this.curItem = null;
        }
        while (!this.queue.isEmpty()) {
            ItemFactory<T> nextFactory = this.queue.poll();
            try {
                this.curItem = nextFactory.newItem();
                return true;
            }
            catch (IOException e) {
                this.curItem = null;
                LOG.debug("Failed to create new item", (Throwable)e);
                this.suppressed.add(e);
            }
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.curItem != null) {
            this.curItem.close();
        }
    }

    public static <T extends Closeable> Builder<T> builder() {
        return new Builder();
    }

    public static interface Task<T extends Closeable, R> {
        public R run(T var1) throws IOException;
    }

    public static interface ItemFactory<T extends Closeable> {
        public T newItem() throws IOException;
    }

    public static class Builder<T extends Closeable> {
        private final Deque<ItemFactory<T>> factories = Queues.newArrayDeque();
        private Predicate<IOException> shouldContinue;

        public Builder<T> addFirst(ItemFactory<T> factory) {
            this.factories.addFirst(factory);
            return this;
        }

        public Builder<T> addLast(ItemFactory<T> factory) {
            this.factories.addLast(factory);
            return this;
        }

        public Builder<T> shouldContinue(Predicate<IOException> continueCondition) {
            this.shouldContinue = continueCondition;
            return this;
        }

        public Chain<T> build() throws IOException {
            Chain<Closeable> chain = new Chain<Closeable>(this.factories, this.shouldContinue);
            chain.run(item -> null);
            return chain;
        }
    }
}

