/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.common;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.util.Preconditions;

public final class Bytes {
    private Bytes() {
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static byte[] toBytes(byte b) {
        return new byte[]{b};
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        for (int i = 1; i >= 0; --i) {
            b[i] = (byte)val;
            val = (short)(val >>> 8);
        }
        return b;
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i >= 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        return b;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i >= 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        return b;
    }

    public static byte[] toBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static long toLong(byte[] b) {
        return Bytes.toLong(b, 0, 8);
    }

    public static long toLong(byte[] b, int off, int len) {
        Preconditions.checkArgument((len == 8 ? 1 : 0) != 0, (String)"Invalid len: %s", (Object[])new Object[]{len});
        Preconditions.checkArgument((off >= 0 && off + len <= b.length ? 1 : 0) != 0, (String)"Invalid off: %s, len: %s, array size: %s", (Object[])new Object[]{off, len, b.length});
        long l = 0L;
        for (int i = off; i < off + len; ++i) {
            l <<= 8;
            l ^= (long)(b[i] & 0xFF);
        }
        return l;
    }

    public static byte[] toBytes(byte[] b, int off, int len) {
        Preconditions.checkArgument((off >= 0 ? 1 : 0) != 0, (String)"off %s must be >=0", (Object[])new Object[]{off});
        Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (String)"len %s must be >= 0", (Object[])new Object[]{len});
        Preconditions.checkArgument((off + len <= b.length ? 1 : 0) != 0, (String)"off (%s) + len (%s) must be <= %s", (Object[])new Object[]{off, len, b.length});
        byte[] data = new byte[len];
        System.arraycopy(b, off, data, 0, len);
        return data;
    }

    public static String toString(byte[] b) {
        return new String(b, StandardCharsets.UTF_8);
    }

    public static String toString(byte[] b, int off, int len) {
        return new String(b, off, len, StandardCharsets.UTF_8);
    }
}

