/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit.ops;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.tosfs.commit.Pending;
import org.apache.hadoop.fs.tosfs.commit.ops.PendingOps;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawPendingOps
implements PendingOps {
    private static final Logger LOG = LoggerFactory.getLogger(RawPendingOps.class);
    private final ObjectStorage storage;

    public RawPendingOps(FileSystem fs, ObjectStorage storage) {
        this.storage = storage;
    }

    @Override
    public void revert(Pending commit) {
        LOG.info("Revert the commit by deleting the object key - {}", (Object)commit);
        this.storage.delete(commit.destKey());
    }

    @Override
    public void abort(Pending commit) {
        LOG.info("Abort the commit by aborting multipart upload - {}", (Object)commit);
        this.storage.abortMultipartUpload(commit.destKey(), commit.uploadId());
    }

    @Override
    public void commit(Pending commit) {
        LOG.info("Commit by completing the multipart uploads - {}", (Object)commit);
        this.storage.completeUpload(commit.destKey(), commit.uploadId(), commit.parts());
    }
}

