/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit.ops;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.tosfs.commit.ops.PendingOps;
import org.apache.hadoop.fs.tosfs.commit.ops.RawPendingOps;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;

public final class PendingOpsFactory {
    public static final String PENDING_OPS_IMPL = "pending.ops.impl";
    public static final String DEFAULT_PENDING_OPS_IMPL = RawPendingOps.class.getName();

    private PendingOpsFactory() {
    }

    public static PendingOps create(FileSystem fs, ObjectStorage storage) {
        try {
            String opsImpl = fs.getConf().get(PENDING_OPS_IMPL, DEFAULT_PENDING_OPS_IMPL);
            Class<?> clazz = Class.forName(opsImpl);
            return (PendingOps)clazz.getDeclaredConstructor(FileSystem.class, ObjectStorage.class).newInstance(fs, storage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

