/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.tosfs.commit.CommitUtils;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Committer
extends FileOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(Committer.class);
    private OutputCommitter wrapped = null;

    private static Path getOutputPath(org.apache.hadoop.mapred.JobContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath((JobConf)conf);
    }

    private static Path getOutputPath(org.apache.hadoop.mapred.TaskAttemptContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath((JobConf)conf);
    }

    private OutputCommitter getWrapped(org.apache.hadoop.mapred.JobContext context) throws IOException {
        if (this.wrapped == null) {
            this.wrapped = CommitUtils.supportObjectStorageCommit(context.getConfiguration(), Committer.getOutputPath(context)) ? new org.apache.hadoop.fs.tosfs.commit.Committer(Committer.getOutputPath(context), (JobContext)context) : new FileOutputCommitter();
            LOG.debug("Using OutputCommitter implementation {}", (Object)this.wrapped.getClass().getName());
        }
        return this.wrapped;
    }

    @InterfaceAudience.Private
    public Path getTaskAttemptPath(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        Path out = Committer.getOutputPath(context);
        return out == null ? null : this.getTaskAttemptPath(context, out);
    }

    private OutputCommitter getWrapped(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        if (this.wrapped == null) {
            this.wrapped = CommitUtils.supportObjectStorageCommit(context.getConfiguration(), Committer.getOutputPath(context)) ? new org.apache.hadoop.fs.tosfs.commit.Committer(Committer.getOutputPath(context), (TaskAttemptContext)context) : new FileOutputCommitter();
        }
        return this.wrapped;
    }

    public Path getWorkPath(org.apache.hadoop.mapred.TaskAttemptContext context, Path outputPath) throws IOException {
        if (this.getWrapped(context) instanceof org.apache.hadoop.fs.tosfs.commit.Committer) {
            return ((org.apache.hadoop.fs.tosfs.commit.Committer)this.getWrapped(context)).getWorkPath();
        }
        return super.getWorkPath(context, outputPath);
    }

    private Path getTaskAttemptPath(org.apache.hadoop.mapred.TaskAttemptContext context, Path out) throws IOException {
        Path workPath = FileOutputFormat.getWorkOutputPath((JobConf)context.getJobConf());
        if (workPath == null && out != null) {
            if (this.getWrapped(context) instanceof org.apache.hadoop.fs.tosfs.commit.Committer) {
                return CommitUtils.magicTaskAttemptPath((TaskAttemptContext)context, Committer.getOutputPath(context));
            }
            return org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.getTaskAttemptPath((TaskAttemptContext)context, (Path)out);
        }
        return workPath;
    }

    public void setupJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        this.getWrapped(context).setupJob((JobContext)context);
    }

    public void commitJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        this.getWrapped(context).commitJob((JobContext)context);
    }

    @Deprecated
    public void cleanupJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        this.getWrapped(context).cleanupJob((JobContext)context);
    }

    public void abortJob(org.apache.hadoop.mapred.JobContext context, int runState) throws IOException {
        JobStatus.State state;
        if (runState == JobStatus.State.RUNNING.getValue()) {
            state = JobStatus.State.RUNNING;
        } else if (runState == JobStatus.State.SUCCEEDED.getValue()) {
            state = JobStatus.State.SUCCEEDED;
        } else if (runState == JobStatus.State.FAILED.getValue()) {
            state = JobStatus.State.FAILED;
        } else if (runState == JobStatus.State.PREP.getValue()) {
            state = JobStatus.State.PREP;
        } else if (runState == JobStatus.State.KILLED.getValue()) {
            state = JobStatus.State.KILLED;
        } else {
            throw new IllegalArgumentException(runState + " is not a valid runState.");
        }
        this.getWrapped(context).abortJob((JobContext)context, state);
    }

    public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).setupTask((TaskAttemptContext)context);
    }

    public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).commitTask((TaskAttemptContext)context);
    }

    public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).abortTask((TaskAttemptContext)context);
    }

    public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        return this.getWrapped(context).needsTaskCommit((TaskAttemptContext)context);
    }

    @Deprecated
    public boolean isRecoverySupported() {
        return false;
    }

    public boolean isCommitJobRepeatable(org.apache.hadoop.mapred.JobContext context) throws IOException {
        return this.getWrapped(context).isCommitJobRepeatable((JobContext)context);
    }

    public boolean isRecoverySupported(org.apache.hadoop.mapred.JobContext context) throws IOException {
        return this.getWrapped(context).isRecoverySupported((JobContext)context);
    }

    public void recoverTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).recoverTask((TaskAttemptContext)context);
    }

    public String jobId() {
        Preconditions.checkNotNull((Object)this.wrapped, (Object)"Encountered uninitialized job committer.");
        return this.wrapped instanceof org.apache.hadoop.fs.tosfs.commit.Committer ? ((org.apache.hadoop.fs.tosfs.commit.Committer)this.wrapped).jobId() : null;
    }

    public Path getWorkPath() {
        Preconditions.checkNotNull((Object)this.wrapped, (Object)"Encountered uninitialized job committer.");
        return this.wrapped instanceof org.apache.hadoop.fs.tosfs.commit.Committer ? ((org.apache.hadoop.fs.tosfs.commit.Committer)this.wrapped).getWorkPath() : null;
    }
}

